/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.scenario;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.graphicLoader.MMLGraphicLoader;
import com.bbn.openmap.graphicLoader.scenario.ScenarioGraphic;
import com.bbn.openmap.graphicLoader.scenario.ScenarioPoint;
import com.bbn.openmap.graphicLoader.scenario.TimeStamp;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.time.RealTimeHandler;
import com.bbn.openmap.gui.time.TimeConstants;
import com.bbn.openmap.gui.time.TimeSliderSupport;
import com.bbn.openmap.gui.time.TimerControlButtonPanel;
import com.bbn.openmap.gui.time.TimerRateComboBox;
import com.bbn.openmap.io.CSVFile;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;

public class ScenarioGraphicLoader
extends MMLGraphicLoader
implements Tool,
ComponentListener,
DataBoundsProvider,
RealTimeHandler,
TimeConstants {
    public static final String TOTAL_SCENARIO_MODE = "TOTAL_SCENARIO";
    public static final String SNAPSHOT_SCENARIO_MODE = "SNAPSHOT_SCENARIO";
    public static final String SCENARIO_MODE_CMD = "SCENARIO_MODE_CMD";
    public static final String DefaultTimerIntervalFormat = "HH:mm:ss";
    public static final String DefaultPaceBaselineString = "00:00:00";
    protected String totalScenarioIconName = "totalScenarioTime.png";
    protected String snapshotIconName = "snapshotScenarioTime.png";
    public static final String LocationFileProperty = "locationFile";
    public static final String LocationHeaderProperty = "locationFileHasHeader";
    public static final String IconIndexProperty = "iconIndex";
    public static final String NameIndexProperty = "nameIndex";
    public static final String ActivityFileProperty = "activityFile";
    public static final String ActivityNameIndexProperty = "activityNameIndex";
    public static final String ActivityHeaderProperty = "activityFileHasHeader";
    public static final String LatIndexProperty = "latIndex";
    public static final String LonIndexProperty = "lonIndex";
    public static final String TimeIndexProperty = "timeIndex";
    public static final String EastIsNegProperty = "eastIsNeg";
    public static final String ShowNamesProperty = "showNames";
    public static final String DefaultIconURLProperty = "defaultURL";
    public static final String TimeFormatProperty = "timeFormat";
    public static final String TimerIntervalFormatProperty = "timerIntervalFormat";
    public static final String TimerPaceBaselineProperty = "timerPaceBaseline";
    public static final String ClockIntervalProperty = "clockIntervalMillis";
    public static final String PaceProperty = "pace";
    public static final String TimerRatesProperty = "timerRates";
    protected String locationFile;
    protected boolean locationHeader = true;
    protected int nameIndex;
    protected int iconIndex;
    protected String activityFile;
    protected boolean activityHeader = true;
    protected int activityNameIndex;
    protected int latIndex;
    protected int lonIndex;
    protected int timeIndex;
    protected boolean eastIsNeg = false;
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    protected SimpleDateFormat timerIntervalFormat = new SimpleDateFormat("HH:mm:ss");
    protected String timerPaceBaselineString = "00:00:00";
    protected long startTime = Long.MAX_VALUE;
    protected long endTime = Long.MIN_VALUE;
    protected long time = 0L;
    protected int timeIncrement = 1;
    protected String mode = "TOTAL_SCENARIO";
    protected boolean timeWrap = this.mode == "SNAPSHOT_SCENARIO";
    protected int clockDirection = 1;
    protected String defaultIconURL;
    protected boolean showNames = false;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected ScenarioGraphicList scenarioGraphics = null;
    protected LinkedList timerRates;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected DataBounds dataBounds = new DataBounds();
    protected Date timeDate = null;
    protected JToggleButton timeWrapToggle;
    protected JLabel timeLabel;
    protected TimerControlButtonPanel timerControl;
    protected TimerRateComboBox timerRateControl;
    protected JSlider timeSlider;
    protected TimeSliderSupport timeSliderSupport;

    public ScenarioGraphicLoader() {
        this.setUpdateInterval(500);
    }

    public synchronized void manageGraphics() {
        Projection p = this.getProjection();
        OMGraphicHandler receiver = this.getReceiver();
        boolean DEBUG = Debug.debugging("scenario");
        if (receiver != null && p != null) {
            if (this.scenarioGraphics == null) {
                this.scenarioGraphics = this.createData();
                if (this.timeSliderSupport != null) {
                    this.timeSliderSupport.setStartTime(this.startTime);
                    this.timeSliderSupport.setEndTime(this.endTime);
                }
            }
            long currentTime = this.getTime();
            if (DEBUG) {
                Debug.output("ScenarioGraphicLoader (" + this.getName() + ") snapshot at " + currentTime);
            }
            this.scenarioGraphics.generate(p, currentTime, this.getMode() == TOTAL_SCENARIO_MODE);
            if (DEBUG) {
                Debug.output("ScenarioGraphicLoader (" + this.getName() + ") setting list of " + this.scenarioGraphics.size() + " scenario graphics");
            }
            receiver.setList(this.scenarioGraphics);
        } else {
            Debug.output("ScenarioGraphicLoader (" + this.getName() + ") doesn't have a connection to the map.");
        }
    }

    public void setPace(int pace) {
        this.timeIncrement = pace;
    }

    public int getPace() {
        return this.timeIncrement;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long t) {
        this.time = t;
        if (this.timeDate != null && this.timeLabel != null) {
            this.timeDate.setTime(this.time);
            this.timeLabel.setText(this.timeFormat.format(this.timeDate));
        }
        if (this.timeSliderSupport != null) {
            this.timeSliderSupport.update(this.time);
        }
        this.manageGraphics();
    }

    public void startClock() {
        if (!this.timer.isRunning()) {
            this.pcs.firePropertyChange("TIMER_RUNNING_STATUS", "TIMER_STOPPED", this.getClockDirection() > 0 ? "TIMER_FORWARD" : "TIMER_BACKWARD");
        }
        if (Debug.debugging("scenario")) {
            Debug.output("ScenarioGraphicLoader " + this.getName() + ": Starting clock");
        }
        this.timer.restart();
    }

    public void stopClock() {
        if (this.timer.isRunning()) {
            this.pcs.firePropertyChange("TIMER_RUNNING_STATUS", this.getClockDirection() > 0 ? "TIMER_FORWARD" : "TIMER_BACKWARD", "TIMER_STOPPED");
            this.timer.stop();
        }
    }

    public void setClockDirection(int direction) {
        String newDirection;
        String oldDirection = this.clockDirection > 0 ? "TIMER_FORWARD" : "TIMER_BACKWARD";
        this.clockDirection = direction >= 0 ? 1 : -1;
        String string = newDirection = this.clockDirection > 0 ? "TIMER_FORWARD" : "TIMER_BACKWARD";
        if (this.timer.isRunning() && oldDirection != newDirection) {
            this.pcs.firePropertyChange("TIMER_RUNNING_STATUS", oldDirection, newDirection);
        }
    }

    public int getClockDirection() {
        return this.clockDirection;
    }

    protected void changeTimeBy(long amount) {
        this.changeTimeBy(amount, this.timeWrap);
    }

    protected void changeTimeBy(long amount, boolean wrapAroundTimeLimits) {
        long newTime;
        long oldTime = this.getTime();
        if (oldTime > this.endTime || oldTime < this.startTime) {
            if (wrapAroundTimeLimits) {
                newTime = amount >= 0L ? this.startTime + amount : this.endTime + amount;
            } else {
                newTime = amount >= 0L ? this.startTime : this.endTime;
                if (this.timer.isRunning()) {
                    this.stopClock();
                    this.setTime(newTime);
                    return;
                }
            }
        } else {
            newTime = oldTime + amount;
        }
        if (Debug.debugging("scenario")) {
            Debug.output("ScenarioGraphicLoader (" + this.getName() + ") changing time by [" + amount + "] to (" + newTime + ")");
        }
        this.setTime(newTime);
    }

    public void stepForward() {
        this.changeTimeBy(this.timeIncrement, true);
    }

    public void stepBackward() {
        this.changeTimeBy(-this.timeIncrement, true);
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == SCENARIO_MODE_CMD) {
            this.timeWrap = ((JToggleButton)ae.getSource()).isSelected();
        } else {
            this.changeTimeBy(this.timeIncrement * this.clockDirection);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ScenarioGraphicList createData() {
        list = new ScenarioGraphicList();
        library = new Hashtable<String, ScenarioPoint>();
        if (this.locationFile != null && this.nameIndex != -1) {
            Debug.message("scenario", "Reading location file...");
            try {
                locations = new CSVFile(this.locationFile);
                locations.loadData();
                records = locations.iterator();
                while (records.hasNext()) {
                    name = null;
                    icon = null;
                    record = (Vector)records.next();
                    if (record.size() == 0) continue;
                    name = (String)record.elementAt(this.nameIndex);
                    if (this.iconIndex != -1) {
                        icon = (String)record.elementAt(this.iconIndex);
                    }
                    if (name != null) {
                        location = new ScenarioPoint(name, icon);
                        location.setShowName(this.showNames);
                        this.drawingAttributes.setTo(location);
                        library.put(name.intern(), location);
                        list.add(location);
                        continue;
                    }
                    Debug.error("ScenaroGraphicLoader: no name to use to create location: " + name);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("ScenarioGraphicLoader: problem finding the location file: " + this.locationFile);
                return list;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                Debug.error("ScenarioGraphicLoader: problem with parsing location file: " + this.locationFile);
                if (!Debug.debugging("scenario")) ** GOTO lbl42
                Debug.output("The problem is with one of the indexes into the file: \n" + aioobe.getMessage());
                aioobe.printStackTrace();
            }
            catch (NullPointerException npe) {
                Debug.error("ScenarioGraphicLoader (" + this.getName() + ") null pointer exception, most likely a problem finding the organization data file");
            }
        } else {
            Debug.error("ScenarioGraphicLoader(" + this.getName() + "): Location file (" + this.locationFile + ") not configured.");
            return list;
        }
lbl42:
        // 4 sources

        if (this.activityFile != null && this.activityNameIndex != -1 && this.latIndex != -1 && this.lonIndex != -1 && this.timeIndex != -1) {
            Debug.message("scenario", "Reading activity file...");
            try {
                activities = new CSVFile(this.activityFile);
                activities.loadData();
                records = activities.iterator();
                while (records.hasNext()) {
                    name = null;
                    record = (Vector)records.next();
                    if (record.size() == 0) continue;
                    name = record.elementAt(this.activityNameIndex).toString().intern();
                    try {
                        lat = ((Double)record.elementAt(this.latIndex)).floatValue();
                        lon = ((Double)record.elementAt(this.lonIndex)).floatValue();
                        timeString = (String)record.elementAt(this.timeIndex);
                        this.timeDate = this.timeFormat.parse(timeString);
                        time = this.timeDate.getTime();
                        if (time < this.startTime) {
                            this.startTime = time;
                        }
                        if (time > this.endTime) {
                            this.endTime = time;
                        }
                        this.dataBounds.add(lon, lat);
                        if (name != null) {
                            point = (ScenarioPoint)library.get(name);
                            if (point != null) {
                                ts = new TimeStamp(lat, lon, time);
                                point.addTimeStamp(ts);
                                continue;
                            }
                            Debug.error("SenaroGraphicLoader: ScenarioPoint not found for " + name + ", entry: " + record);
                            continue;
                        }
                        Debug.error("SenaroGraphicLoader: no name to use to create activity point: " + name);
                    }
                    catch (ClassCastException cce) {
                        obj0 = record.elementAt(this.activityNameIndex);
                        obj1 = record.elementAt(this.latIndex);
                        obj2 = record.elementAt(this.lonIndex);
                        obj3 = record.elementAt(this.timeIndex);
                        Debug.error("ScenarioGraphicLoader(" + this.getName() + ") has problem with indexes in activity file for " + obj0 + " (" + obj0.getClass().getName() + ")" + ":\n\tlat index = " + this.latIndex + ", value = " + obj1 + " (" + obj1.getClass().getName() + ")\n\t lon index = " + this.lonIndex + ", value = " + obj2 + " (" + obj2.getClass().getName() + ")\n\t time index = " + this.timeIndex + ", value = " + obj3 + " (" + obj3.getClass().getName() + ")");
                    }
                    catch (ParseException pe) {
                        Debug.output("ScenarioGraphicLoader(" + this.getName() + ") has problem with time format. " + pe.getMessage());
                    }
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("ScenarioGraphicLoader: problem with activity file: " + this.activityFile);
                return list;
            }
            catch (NullPointerException npe) {
                Debug.error("ScenarioGraphicLoader (" + this.getName() + ") null pointer exception, most likely a problem finding the activites data file");
            }
        } else {
            Debug.error("ScenarioGraphicLoader(" + this.getName() + "): Activity file (" + this.activityFile + ") not configured.");
            return list;
        }
        this.time = this.startTime;
        Debug.message("scenario", "Reading files OK");
        return list;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.drawingAttributes.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.locationFile = properties.getProperty(prefix + LocationFileProperty);
        this.iconIndex = PropUtils.intFromProperties(properties, prefix + IconIndexProperty, -1);
        this.nameIndex = PropUtils.intFromProperties(properties, prefix + NameIndexProperty, -1);
        this.activityNameIndex = PropUtils.intFromProperties(properties, prefix + ActivityNameIndexProperty, -1);
        this.activityFile = properties.getProperty(prefix + ActivityFileProperty);
        this.latIndex = PropUtils.intFromProperties(properties, prefix + LatIndexProperty, -1);
        this.lonIndex = PropUtils.intFromProperties(properties, prefix + LonIndexProperty, -1);
        this.timeIndex = PropUtils.intFromProperties(properties, prefix + TimeIndexProperty, -1);
        this.eastIsNeg = PropUtils.booleanFromProperties(properties, prefix + EastIsNegProperty, this.eastIsNeg);
        this.showNames = PropUtils.booleanFromProperties(properties, prefix + ShowNamesProperty, this.showNames);
        this.defaultIconURL = properties.getProperty(prefix + DefaultIconURLProperty);
        this.locationHeader = PropUtils.booleanFromProperties(properties, prefix + LocationHeaderProperty, false);
        this.activityHeader = PropUtils.booleanFromProperties(properties, prefix + ActivityHeaderProperty, false);
        String timeFormatString = properties.getProperty(prefix + TimeFormatProperty, this.timeFormat.toPattern());
        this.timeFormat = new SimpleDateFormat(timeFormatString);
        String timerIntervalFormatString = properties.getProperty(prefix + TimerIntervalFormatProperty, this.timerIntervalFormat.toPattern());
        this.timerPaceBaselineString = properties.getProperty(prefix + TimerPaceBaselineProperty, this.timerPaceBaselineString);
        this.timerIntervalFormat = new SimpleDateFormat(timerIntervalFormatString);
        if (Debug.debugging("scenario")) {
            Debug.output("ScenarioGraphicLoader timer rate pace pattern: " + timerIntervalFormatString);
        }
        String timerRatesString = properties.getProperty(prefix + TimerRatesProperty);
        this.timerRates = new LinkedList();
        if (timerRatesString != null) {
            if (Debug.debugging("scenario")) {
                Debug.output("ScenarioGraphicLoader reading timer rates: " + timerRatesString);
            }
            Vector rates = PropUtils.parseSpacedMarkers(timerRatesString);
            Iterator it = rates.iterator();
            while (it.hasNext()) {
                String ratePrefix = (String)it.next();
                TimerRateHolder trh = new TimerRateHolder(this.timerIntervalFormat, this.timerPaceBaselineString);
                trh.setProperties(prefix + ratePrefix, properties);
                if (trh.valid) {
                    this.timerRates.add(trh);
                    if (!Debug.debugging("scenario")) continue;
                    Debug.output("ScenarioGraphicLoader adding " + trh);
                    continue;
                }
                if (!Debug.debugging("scenario")) continue;
                Debug.output("ScenarioGraphicLoader NOT adding " + ratePrefix);
            }
        } else if (Debug.debugging("scenario")) {
            Debug.output("ScenarioGraphicLoader has no timer rate information");
        }
        if (Debug.debugging("scenario")) {
            Debug.output("ScenarioGraphicLoader indexes:\n\tlocation file: " + this.locationFile + "\n\tlocation file has header: " + this.locationHeader + "\n\tnameIndex = " + this.nameIndex + "\n\ticonIndex = " + this.iconIndex + "\n\tactivity file: " + this.activityFile + "\n\tactivity file has header: " + this.activityHeader + "\n\tlatIndex = " + this.latIndex + "\n\tlonIndex = " + this.lonIndex + "\n\ttimeIndex = " + this.timeIndex);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + LocationFileProperty, PropUtils.unnull(this.locationFile));
        props.put(prefix + LocationHeaderProperty, new Boolean(this.locationHeader).toString());
        props.put(prefix + NameIndexProperty, this.nameIndex != -1 ? Integer.toString(this.nameIndex) : "");
        props.put(prefix + ActivityFileProperty, PropUtils.unnull(this.activityFile));
        props.put(prefix + ActivityHeaderProperty, new Boolean(this.activityHeader).toString());
        props.put(prefix + ActivityNameIndexProperty, this.activityNameIndex != -1 ? Integer.toString(this.activityNameIndex) : "");
        props.put(prefix + EastIsNegProperty, new Boolean(this.eastIsNeg).toString());
        props.put(prefix + ShowNamesProperty, new Boolean(this.showNames).toString());
        props.put(prefix + LatIndexProperty, this.latIndex != -1 ? Integer.toString(this.latIndex) : "");
        props.put(prefix + LonIndexProperty, this.lonIndex != -1 ? Integer.toString(this.lonIndex) : "");
        props.put(prefix + TimeIndexProperty, this.timeIndex != -1 ? Integer.toString(this.timeIndex) : "");
        props.put(prefix + IconIndexProperty, this.iconIndex != -1 ? Integer.toString(this.iconIndex) : "");
        props.put(prefix + DefaultIconURLProperty, PropUtils.unnull(this.defaultIconURL));
        this.drawingAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(LocationFileProperty, "URL of file containing location information.");
        list.put("locationFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put(LocationHeaderProperty, "Location file has a header row to be ignored.");
        list.put("locationFileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(ActivityFileProperty, "URL of file containing scenario activity information.");
        list.put("activityFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put(ActivityHeaderProperty, "Activity file has a header row to be ignored.");
        list.put("activityFileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(EastIsNegProperty, "Flag to note that negative latitude are over the eastern hemisphere.");
        list.put("eastIsNeg.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(ShowNamesProperty, "Flag to note that locations should display their names.");
        list.put("showNames.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(NameIndexProperty, "The column index, in the location file, of the location label text.");
        list.put(ActivityNameIndexProperty, "The column index, in the activity file, of the location label text.");
        list.put(LatIndexProperty, "The column index, in the activity file, of the latitudes.");
        list.put(LonIndexProperty, "The column index, in the activity file, of the longitudes.");
        list.put(TimeIndexProperty, "The column index, in the activity file, of the time of the activity.");
        list.put(IconIndexProperty, "The column index, in the location file, of the icon for locations (optional).");
        list.put(DefaultIconURLProperty, "The URL of an image file to use as a default for the location markers (optional).");
        this.drawingAttributes.getPropertyInfo(list);
        return list;
    }

    public Container getFace() {
        JPanel jtb = new JPanel();
        Box bigBox = Box.createHorizontalBox();
        Box rightBox = Box.createVerticalBox();
        Box leftBox = Box.createVerticalBox();
        Box innerBox = Box.createHorizontalBox();
        try {
            URL url = PropUtils.getResourceOrFileOrURL(this, this.snapshotIconName);
            ImageIcon snapshotIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.totalScenarioIconName);
            ImageIcon totalScenarioIcon = new ImageIcon(url);
            this.timeWrapToggle = new JToggleButton(totalScenarioIcon, this.timeWrap);
            this.timeWrapToggle.setSelectedIcon(snapshotIcon);
            this.timeWrapToggle.setActionCommand(SCENARIO_MODE_CMD);
            this.timeWrapToggle.addActionListener(this);
            this.timeWrapToggle.setToolTipText("Wrap Scenario Time Scale");
            innerBox.add(this.timeWrapToggle);
        }
        catch (MalformedURLException murle) {
            Debug.error("ScenarioGraphicLoader " + this.getName() + ":" + murle.getMessage());
        }
        catch (NullPointerException npe) {
            Debug.error("ScenarioGraphicLoader " + this.getName() + ":" + npe.getMessage());
        }
        this.timerControl = new TimerControlButtonPanel(this);
        innerBox.add(this.timerControl);
        rightBox.add(innerBox);
        this.pcs.addPropertyChangeListener("TIMER_RUNNING_STATUS", this.timerControl);
        String runningStatus = this.timer.isRunning() ? (this.getClockDirection() > 0 ? "TIMER_FORWARD" : "TIMER_BACKWARD") : "TIMER_STOPPED";
        this.pcs.firePropertyChange("TIMER_RUNNING_STATUS", null, runningStatus);
        this.timerRateControl = new TimerRateComboBox(this);
        this.timerRateControl.setToolTipText("Change clock rate for Scenario");
        Iterator it = this.timerRates.iterator();
        while (it.hasNext()) {
            TimerRateHolder trh = (TimerRateHolder)it.next();
            this.timerRateControl.add(trh.label, trh.clock, trh.pace);
        }
        int si = this.timerRates.size() / 2;
        if (si > 0) {
            this.timerRateControl.setSelectedIndex(si);
        }
        rightBox.add(this.timerRateControl);
        this.timeSlider = new JSlider(0, 0, 100, 0);
        this.timeSliderSupport = new TimeSliderSupport(this.timeSlider, this, this.startTime, this.endTime);
        leftBox.add(this.timeSlider);
        this.timeLabel = new JLabel(" ", 0);
        Font defaultFont = this.timeLabel.getFont();
        this.timeLabel.setFont(new Font(defaultFont.getName(), defaultFont.getStyle(), 10));
        leftBox.add(this.timeLabel);
        URL url = ScenarioGraphicLoader.class.getResource("path.png");
        ImageIcon icon = new ImageIcon(url);
        JToggleButton modeButton = new JToggleButton(icon, this.mode == TOTAL_SCENARIO_MODE);
        modeButton.setToolTipText((this.mode == TOTAL_SCENARIO_MODE ? "Hide" : "Show") + " scenario paths on " + this.getName());
        modeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JToggleButton jtb = (JToggleButton)ae.getSource();
                boolean sel = jtb.isSelected();
                ScenarioGraphicLoader.this.setMode(sel ? ScenarioGraphicLoader.TOTAL_SCENARIO_MODE : ScenarioGraphicLoader.SNAPSHOT_SCENARIO_MODE);
                jtb.setToolTipText((sel ? "Hide" : "Show") + " scenario paths on " + ScenarioGraphicLoader.this.getName());
                ScenarioGraphicLoader.this.manageGraphics();
            }
        });
        bigBox.add(modeButton);
        bigBox.add(leftBox);
        bigBox.add(rightBox);
        jtb.add(bigBox);
        return jtb;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getKey() {
        return this.getName();
    }

    public void setKey(String aKey) {
        this.setName(aKey);
    }

    public DataBounds getDataBounds() {
        return this.dataBounds;
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentHidden(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
    }

    public class TimerRateHolder
    implements PropertyConsumer {
        String label;
        int clock;
        int pace;
        SimpleDateFormat paceFormat;
        String paceZero;
        boolean valid = false;
        String propPrefix;

        public TimerRateHolder(SimpleDateFormat simpleDateFormat, String dpz) {
            this.paceFormat = simpleDateFormat;
            this.paceZero = dpz;
        }

        public String toString() {
            return "ScenarioGraphicLoader.TimerRateHolder [" + this.label + ", clock:" + this.clock + ", pace:" + this.pace + "] (" + this.valid + ")";
        }

        public void setProperties(Properties props) {
            this.setProperties(null, props);
        }

        public void setProperties(String prefix, Properties props) {
            this.propPrefix = prefix;
            prefix = PropUtils.getScopedPropertyPrefix(prefix);
            try {
                this.label = props.getProperty(prefix + "prettyName");
                this.clock = PropUtils.intFromProperties(props, prefix + ScenarioGraphicLoader.ClockIntervalProperty, -1);
                String paceString = props.getProperty(prefix + ScenarioGraphicLoader.PaceProperty);
                this.pace = (int)(this.paceFormat.parse(paceString).getTime() - this.paceFormat.parse(this.paceZero).getTime());
                this.valid = true;
            }
            catch (NullPointerException npe) {
                Debug.error("TimerRateHolder caught NPE: " + npe.getMessage());
            }
            catch (ParseException pe) {
                Debug.error("TimerRateHolder parse exception: " + pe.getMessage());
            }
        }

        public Properties getProperties(Properties props) {
            return props;
        }

        public Properties getPropertyInfo(Properties props) {
            return props;
        }

        public String getPropertyPrefix() {
            return this.propPrefix;
        }

        public void setPropertyPrefix(String p) {
            this.propPrefix = p;
        }
    }

    public class ScenarioGraphicList
    extends OMGraphicList {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate(Projection p, long time, boolean showScenario) {
            List list = this.graphics;
            synchronized (list) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    OMGraphic graphic = (OMGraphic)it.next();
                    if (graphic instanceof ScenarioGraphic) {
                        ((ScenarioGraphic)((Object)graphic)).generate(p, time, showScenario);
                        continue;
                    }
                    graphic.generate(p);
                }
            }
        }
    }
}

