/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Ribbon;
import com.bbn.openmap.geo.Rotation;

public class RibbonIterator {
    protected Geo v1;
    protected Geo v2;
    protected double radius;
    protected Geo gc;
    protected Rotation rotator;
    protected Geo point;
    protected double distance;
    protected boolean hasNext;

    public RibbonIterator(Geo v1, Geo v2, double radius) {
        this.v1 = v1;
        this.v2 = v2;
        this.distance = v1.distance(v2);
        this.radius = radius;
        this.gc = v1.crossNormalize(v2);
        this.rotator = new Rotation(this.gc, 2.0 * radius);
        this.point = v1;
        this.hasNext = true;
    }

    public Object next() {
        if (this.point != this.v2 && this.v1.distance(this.point) < this.distance) {
            Ribbon result = new Ribbon(this.point, this.gc, this.radius);
            this.point = this.rotator.rotate(this.point);
            return result;
        }
        this.point = this.v2;
        return new Ribbon(this.point, this.gc, this.radius);
    }

    public boolean hasNext() {
        return this.point != this.v2;
    }

    public void remove() {
    }
}

