/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.geo.Intersection;

public interface GeoRegion
extends GeoPath {
    public boolean isPointInside(Geo var1);

    public static class Impl
    extends GeoPath.Impl
    implements GeoRegion {
        public Impl(Geo[] coords) {
            super(coords);
        }

        public Impl(float[] lls) {
            this(lls, true);
        }

        public Impl(float[] lls, boolean isDegrees) {
            super(lls, isDegrees);
        }

        public void setRegionId(Object rid) {
            this.id = rid;
        }

        public Object getRegionId() {
            return this.id;
        }

        public boolean isSegmentNear(GeoSegment s, double epsilon) {
            return Intersection.isSegmentNearPolyRegion(s, this.getPoints(), epsilon);
        }

        public boolean isPointInside(Geo p) {
            return Intersection.isPointInPolygon(p, this.getPoints());
        }

        public BoundingCircle getBoundingCircle() {
            if (this.bc == null) {
                return new BoundingCircle.Impl(this);
            }
            return this.bc;
        }
    }
}

