/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.geo.Intersection;
import java.util.Iterator;

public interface GeoPath
extends GeoExtent {
    public SegmentIterator segmentIterator();

    public PointIterator pointIterator();

    public boolean isSegmentNear(GeoSegment var1, double var2);

    public GeoArray getPoints();

    public int length();

    public static class Impl
    implements GeoPath {
        protected GeoArray pts;
        protected int length;
        protected Object id = this;
        protected transient BoundingCircle bc = null;

        protected Impl() {
        }

        public Impl(float[] lls) {
            this(lls, true);
        }

        public Impl(float[] lls, boolean isDegrees) {
            this.pts = isDegrees ? GeoArray.Float.createFromLatLonDegrees(lls) : GeoArray.Float.createFromLatLonRadians(lls);
            this.length = this.pts.getSize();
        }

        public Impl(Geo[] geos) {
            this.setPoints(geos);
        }

        public void setPoints(GeoArray ga) {
            this.pts = ga;
            this.length = this.pts != null ? this.pts.getSize() : 0;
        }

        public GeoArray getPoints() {
            return this.pts;
        }

        protected void setPoints(Geo[] points) {
            this.pts = new GeoArray.Float(points);
            this.length = this.pts != null ? this.pts.getSize() : 0;
        }

        public boolean isSegmentNear(GeoSegment s, double epsilon) {
            return Intersection.isSegmentNearPoly(s, this.getPoints(), epsilon) != null;
        }

        public synchronized BoundingCircle getBoundingCircle() {
            if (this.bc == null) {
                this.bc = new BoundingCircle.Impl(this);
            }
            return this.bc;
        }

        public int length() {
            return this.length;
        }

        public SegmentIterator segmentIterator() {
            return new SegIt();
        }

        public PointIterator pointIterator() {
            return new PointIt();
        }

        protected Object getSegID(int i) {
            return new Integer(i);
        }

        protected Object getPointID(int i) {
            return new Integer(i);
        }

        public Object getPathID() {
            return this.id;
        }

        public Object getID() {
            return this.id;
        }

        public void setID(Object id) {
            this.id = id;
        }

        protected class PointIt
        implements PointIterator,
        GeoPoint {
            int i = -1;
            Geo pt = new Geo();

            public boolean hasNext() {
                return this.i < Impl.this.length - 1;
            }

            public Object next() {
                return this.nextPoint();
            }

            public GeoPoint nextPoint() {
                ++this.i;
                return this;
            }

            public void remove() {
                throw new UnsupportedOperationException("Path.Iterator doesn't support remove");
            }

            public Geo getPoint() {
                return Impl.this.pts.get(this.i, this.pt);
            }

            public Object getPointId() {
                return Impl.this.getPointID(this.i);
            }

            public Object getID() {
                return Impl.this.getPointID(this.i);
            }

            public BoundingCircle getBoundingCircle() {
                return new BoundingCircle.Impl(Impl.this.pts.get(this.i), 0.0);
            }
        }

        protected class SegIt
        implements SegmentIterator,
        GeoSegment {
            int i = -1;
            Geo[] seg = new Geo[]{new Geo(), new Geo()};

            public SegIt() {
                Impl.this.pts.get(0, this.seg[1]);
            }

            public BoundingCircle getBoundingCircle() {
                Geo c = Intersection.center(this.seg);
                return new BoundingCircle.Impl(c, c.distance(this.seg[0]));
            }

            public boolean hasNext() {
                return this.i < Impl.this.length - 2;
            }

            public Object next() {
                return this.nextSegment();
            }

            public GeoSegment nextSegment() {
                ++this.i;
                this.seg[0].initialize(this.seg[1]);
                Impl.this.pts.get(this.i + 1, this.seg[1]);
                return this;
            }

            public void remove() {
                throw new UnsupportedOperationException("Path.SegmentIterator doesn't support remove");
            }

            public Geo[] getSeg() {
                return this.seg;
            }

            public float[] getSegArray() {
                return new float[]{(float)this.seg[0].getLatitude(), (float)this.seg[0].getLongitude(), (float)this.seg[1].getLatitude(), (float)this.seg[1].getLongitude()};
            }

            public Object getSegId() {
                return Impl.this.getSegID(this.i);
            }

            public Object getID() {
                return Impl.this.getSegID(this.i);
            }
        }
    }

    public static interface PointIterator
    extends Iterator {
        public boolean hasNext();

        public Object next();

        public GeoPoint nextPoint();
    }

    public static interface SegmentIterator
    extends Iterator {
        public boolean hasNext();

        public Object next();

        public GeoSegment nextSegment();
    }
}

