/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.crew;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.Projection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class RouteLayer
extends Layer
implements MapMouseListener {
    private OMGraphicList omgraphics = new OMGraphicList();
    private Projection projection;
    private OMGraphic selectedGraphic;

    public RouteLayer() {
        this.createGraphics(this.omgraphics);
    }

    public OMLine createLine(float lat1, float lng1, float lat2, float lng2, int lineType, Color color, Color selColor) {
        OMLine line = new OMLine(lat1, lng1, lat2, lng2, lineType);
        line.setLinePaint(color);
        line.setSelectPaint(selColor);
        return line;
    }

    public OMGraphicList createGraphics(OMGraphicList graphics) {
        graphics.clear();
        graphics.addOMGraphic(this.createLine(42.0f, -71.0f, 35.5f, -120.5f, 3, Color.red, Color.yellow));
        graphics.addOMGraphic(this.createLine(28.0f, -81.0f, 47.0f, -122.0f, 3, Color.green, Color.yellow));
        graphics.addOMGraphic(this.createLine(22.6f, -101.0f, 44.0f, -70.0f, 3, Color.blue, Color.yellow));
        return graphics;
    }

    public void paint(Graphics g) {
        this.omgraphics.render(g);
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public void projectionChanged(ProjectionEvent e) {
        this.projection = e.getProjection().makeClone();
        this.omgraphics.project(this.projection, true);
        this.repaint();
    }

    public String[] getMouseModeServiceList() {
        String[] ret = new String[]{SelectMouseMode.modeID};
        return ret;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.selectedGraphic != null) {
            switch (e.getClickCount()) {
                case 1: {
                    System.out.println("Show Info: " + this.selectedGraphic);
                    break;
                }
                case 2: {
                    System.out.println("Request URL: " + this.selectedGraphic);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        OMGraphic newSelectedGraphic = this.omgraphics.selectClosest(e.getX(), e.getY(), 2.0f);
        if (newSelectedGraphic != this.selectedGraphic) {
            this.selectedGraphic = newSelectedGraphic;
            this.repaint();
        }
        return true;
    }

    public void mouseMoved() {
        this.omgraphics.deselectAll();
        this.repaint();
    }
}

