/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.proj.Projection;
import java.util.Vector;

public class ProjectionSupport
extends ListenerSupport {
    protected ProjectionChangeNotifier pcNotifier = new ProjectionChangeNotifier();

    public ProjectionSupport() {
        this(null);
    }

    public ProjectionSupport(Object aSource) {
        super(aSource);
        this.pcNotifier.start();
    }

    public void addProjectionListener(ProjectionListener l) {
        this.addListener(l);
    }

    public void removeProjectionListener(ProjectionListener l) {
        this.removeListener(l);
    }

    public void fireProjectionChanged(Projection proj) {
        if (proj == null || this.size() == 0) {
            return;
        }
        this.pcNotifier.fireProjectionEvent(new ProjectionEvent(this.getSource(), proj));
    }

    public void dispose() {
        this.pcNotifier.setTerminated(true);
        super.removeAll();
    }

    protected class ProjectionChangeNotifier
    extends Thread {
        private final Object lock = new Object();
        protected ProjectionEvent projEvent;
        protected ProjectionEvent nextEvent;
        protected boolean terminated = false;

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }

        protected boolean isEventInProgress() {
            return this.projEvent != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireProjectionEvent(ProjectionEvent event) {
            Object object = this.lock;
            synchronized (object) {
                this.nextEvent = event;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Vector lstnrs = null;
            while (!this.terminated) {
                Object it;
                Object object = this.lock;
                synchronized (object) {
                    if (this.nextEvent != null) {
                        this.projEvent = this.nextEvent;
                        this.nextEvent = null;
                    }
                }
                if (this.projEvent != null && ProjectionSupport.this.listeners != null) {
                    if (lstnrs == null) {
                        lstnrs = (Vector)ProjectionSupport.this.listeners.clone();
                    } else {
                        lstnrs.clear();
                    }
                    lstnrs.addAll(ProjectionSupport.this.listeners);
                    it = lstnrs.iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (this.nextEvent != null) break;
                        if (!(o instanceof ProjectionListener)) continue;
                        ((ProjectionListener)o).projectionChanged(this.projEvent);
                    }
                    it = this.lock;
                    synchronized (it) {
                        this.projEvent = null;
                        continue;
                    }
                }
                try {
                    it = this.lock;
                    synchronized (it) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

