/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ListenerSupport
implements Serializable {
    protected transient Vector listeners;
    protected Object source;

    public ListenerSupport(Object sourceBean) {
        this.setSource(sourceBean);
        Debug.message("listenersupport", "ListenerSupport()");
    }

    protected void setSource(Object src) {
        this.source = src;
    }

    protected Object getSource() {
        return this.source;
    }

    public synchronized void addListener(Object listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
            if (Debug.debugging("listenersupport")) {
                Debug.output("ListenerSupport | addListener " + listener.getClass() + " was added");
            }
        }
    }

    public synchronized void removeListener(Object obj) {
        if (this.listeners != null) {
            this.listeners.removeElement(obj);
        }
    }

    public void removeAll() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public synchronized Iterator iterator() {
        if (this.listeners != null) {
            return new ArrayList(this.listeners).iterator();
        }
        return new ArrayList().iterator();
    }

    public int size() {
        int size = 0;
        if (this.listeners != null) {
            size = this.listeners.size();
        }
        return size;
    }

    public synchronized List getListeners() {
        if (this.listeners == null) {
            return null;
        }
        return (List)this.listeners.clone();
    }

    public void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        List v = this.getListeners();
        if (v != null) {
            Iterator it = v.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Serializable)) continue;
                s.writeObject(obj);
            }
        }
        s.writeObject(null);
    }

    public void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addListener(listenerOrNull);
        }
    }
}

