/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.AbstractMouseMode;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.coordFormatter.BasicCoordInfoFormatter;
import com.bbn.openmap.util.coordFormatter.CoordInfoFormatter;
import com.bbn.openmap.util.coordFormatter.CoordInfoFormatterHandler;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public abstract class CoordMouseMode
extends AbstractMouseMode
implements PropertyChangeListener {
    public InformationDelegator infoDelegator = null;
    public static final String CoordFormatterProperty = "coordFormatter";
    protected CoordInfoFormatter coordFormatter = new BasicCoordInfoFormatter();
    protected CoordInfoFormatterHandler coordFormatterHandler = null;

    public CoordMouseMode() {
    }

    public CoordMouseMode(String modeID, boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
    }

    public void setInfoDelegator(InformationDelegator id) {
        this.infoDelegator = id;
    }

    public InformationDelegator getInfoDelegator() {
        return this.infoDelegator;
    }

    public void mouseMoved(MouseEvent e) {
        this.fireMouseLocation(e);
        super.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.fireMouseLocation(e);
        super.mouseDragged(e);
    }

    public void setActive(boolean active) {
        if (Debug.debugging("mousemode")) {
            Debug.output("CoordMouseMode(" + this.getPrettyName() + "): made active (" + active + ")");
        }
        if (!active && this.infoDelegator != null) {
            this.infoDelegator.requestInfoLine(new InfoDisplayEvent(this, "", 1));
        }
    }

    public void fireMouseLocation(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        LatLonPoint llp = null;
        Debug.message("mousemodedetail", "CoordMouseMode: firing mouse location");
        if (this.infoDelegator != null) {
            if (e.getSource() instanceof MapBean) {
                llp = ((MapBean)e.getSource()).getProjection().inverse(x, y);
            }
            String infoLine = this.coordFormatter.createCoordinateInformationLine(x, y, llp, this);
            InfoDisplayEvent info = new InfoDisplayEvent(this, infoLine, 1);
            this.infoDelegator.requestInfoLine(info);
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof InformationDelegator) {
            Debug.message("mousemode", "NavMouseMode: found InformationDelegator");
            this.setInfoDelegator((InformationDelegator)someObj);
        }
        if (someObj instanceof CoordInfoFormatterHandler) {
            this.setCoordFormatterHandler((CoordInfoFormatterHandler)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof InformationDelegator && this.getInfoDelegator() == (InformationDelegator)someObj) {
            this.setInfoDelegator(null);
        }
        if (someObj instanceof CoordInfoFormatterHandler && someObj == this.getCoordFormatterHandler()) {
            this.setCoordFormatterHandler(null);
        }
    }

    public void setProperties(String prefix, Properties props) {
        Object obj;
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String coordFormatterClassString = props.getProperty(realPrefix + CoordFormatterProperty);
        if (coordFormatterClassString != null && (obj = ComponentFactory.create(coordFormatterClassString, prefix, props)) instanceof CoordInfoFormatter) {
            this.setCoordFormatter((CoordInfoFormatter)obj);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        if (this.coordFormatter != null && this.coordFormatterHandler == null) {
            String prefix = PropUtils.getScopedPropertyPrefix(this);
            props.put(prefix + CoordFormatterProperty, this.coordFormatter.getClass().getName());
            if (this.coordFormatter instanceof PropertyConsumer) {
                this.coordFormatter.getProperties(props);
            }
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        if (this.coordFormatter instanceof PropertyConsumer && this.coordFormatterHandler == null) {
            this.coordFormatter.getPropertyInfo(props);
        }
        return props;
    }

    public CoordInfoFormatter getCoordFormatter() {
        return this.coordFormatter;
    }

    public void setCoordFormatter(CoordInfoFormatter coordFormatter) {
        if (coordFormatter == null) {
            coordFormatter = new BasicCoordInfoFormatter();
        }
        this.coordFormatter = coordFormatter;
    }

    public CoordInfoFormatterHandler getCoordFormatterHandler() {
        return this.coordFormatterHandler;
    }

    public void setCoordFormatterHandler(CoordInfoFormatterHandler coordFormatterHandler) {
        if (this.coordFormatterHandler != null) {
            coordFormatterHandler.removePropertyChangeListener("formatters", this);
        }
        this.coordFormatterHandler = coordFormatterHandler;
        if (this.coordFormatterHandler != null) {
            coordFormatterHandler.addPropertyChangeListener("formatters", this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        CoordInfoFormatter newFormatter = (CoordInfoFormatter)evt.getNewValue();
        if (propertyName.equals("formatters")) {
            this.setCoordFormatter(newFormatter);
        }
    }
}

