/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.DbfInputStream;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MetaDbfTableModel
extends DbfTableModel
implements ShapeConstants {
    public static final int META_RECORDNAME_COLUMN_NUMBER = 0;
    public static final int META_TYPE_COLUMN_NUMBER = 1;
    public static final int META_LENGTH_COLUMN_NUMBER = 2;
    public static final int META_PLACES_COLUMN_NUMBER = 3;
    protected DbfTableModel source = null;
    protected int originalColumnNumber = 0;

    public MetaDbfTableModel(DbfTableModel source) {
        super(4);
        int numColumnCount;
        this.init();
        this.setWritable(true);
        this.source = source;
        this.originalColumnNumber = numColumnCount = source.getColumnCount();
        for (int i = 0; i < numColumnCount; ++i) {
            ArrayList<Object> record = new ArrayList<Object>();
            record.add(source.getColumnName(i));
            record.add(new Byte(source.getType(i)));
            record.add(new Integer(source.getLength(i)));
            record.add(new Integer(source.getDecimalCount(i)));
            this.addRecord(record);
            if (!this.DEBUG) continue;
            Debug.output("Adding record: " + record);
        }
    }

    protected void init() {
        this._names[0] = "Column Name";
        this._names[1] = "Type of Data";
        this._names[2] = "Length of Field";
        this._names[3] = "# of Decimal Places";
        for (int i = 0; i < 4; ++i) {
            this._lengths[i] = 12;
            this._decimalCounts[i] = 0;
            byte type = i < 2 ? DBF_TYPE_CHARACTER.byteValue() : DBF_TYPE_NUMERIC.byteValue();
            this._types[i] = type;
        }
    }

    public ArrayList remove(int columnIndex) {
        ArrayList ret = super.remove(columnIndex);
        if (columnIndex < this.originalColumnNumber) {
            --this.originalColumnNumber;
        }
        return ret;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 && rowIndex < this.originalColumnNumber) {
            return false;
        }
        return this.writable;
    }

    public void setValueAt(Object object, int row, int column) {
        if (column == 1) {
            if ("binary".equals(object) || DBF_TYPE_BINARY.equals(object)) {
                object = DBF_TYPE_BINARY;
            } else if ("character".equals(object) || DBF_TYPE_CHARACTER.equals(object)) {
                object = DBF_TYPE_CHARACTER;
            } else if ("date".equals(object) || DBF_TYPE_DATE.equals(object)) {
                object = DBF_TYPE_DATE;
            } else if ("numeric".equals(object) || DBF_TYPE_NUMERIC.equals(object)) {
                object = DBF_TYPE_NUMERIC;
            } else if ("boolean".equals(object) || DBF_TYPE_LOGICAL.equals(object)) {
                object = DBF_TYPE_LOGICAL;
            } else if ("Memo".equals(object) || DBF_TYPE_MEMO.equals(object)) {
                object = DBF_TYPE_MEMO;
            } else if ("timestamp".equals(object) || DBF_TYPE_TIMESTAMP.equals(object)) {
                object = DBF_TYPE_TIMESTAMP;
            } else if ("long".equals(object) || DBF_TYPE_LONG.equals(object)) {
                object = DBF_TYPE_LONG;
            } else if ("autoincrement".equals(object) || DBF_TYPE_AUTOINCREMENT.equals(object)) {
                object = DBF_TYPE_AUTOINCREMENT;
            } else if ("float".equals(object) || DBF_TYPE_FLOAT.equals(object)) {
                object = DBF_TYPE_FLOAT;
            } else if ("double".equals(object) || DBF_TYPE_DOUBLE.equals(object)) {
                object = DBF_TYPE_DOUBLE;
            } else if ("OLE".equals(object) || DBF_TYPE_OLE.equals(object)) {
                object = DBF_TYPE_OLE;
            } else {
                Debug.error("Rejected " + object + " as input. Use: \n    binary, character, date, boolean, memo, timestamp, long, autoincrement, float, double or OLE");
                return;
            }
            if (this.DEBUG) {
                Debug.output("New value set to " + object);
            }
        }
        super.setValueAt(object, row, column);
    }

    public Object getValueAt(int row, int column) {
        Object cell = super.getValueAt(row, column);
        if (column == 1) {
            if (DBF_TYPE_CHARACTER.equals(cell)) {
                cell = "character";
            } else if (DBF_TYPE_DATE.equals(cell)) {
                cell = "date";
            } else {
                if (DBF_TYPE_NUMERIC.equals(cell)) {
                    return "numeric";
                }
                if (DBF_TYPE_LOGICAL.equals(cell)) {
                    cell = "boolean";
                } else if (DBF_TYPE_MEMO.equals(cell)) {
                    cell = "Memo";
                } else if (DBF_TYPE_BINARY.equals(cell)) {
                    cell = "binary";
                } else if (DBF_TYPE_TIMESTAMP.equals(cell)) {
                    cell = "timestamp";
                } else if (DBF_TYPE_FLOAT.equals(cell)) {
                    cell = "float";
                } else if (DBF_TYPE_DOUBLE.equals(cell)) {
                    cell = "double";
                } else if (DBF_TYPE_LONG.equals(cell)) {
                    cell = "long";
                } else if (DBF_TYPE_AUTOINCREMENT.equals(cell)) {
                    cell = "autoincrement";
                } else if (DBF_TYPE_OLE.equals(cell)) {
                    cell = "OLE";
                }
            }
        }
        return cell;
    }

    public void addBlankRecord() {
        ArrayList<Object> record = new ArrayList<Object>();
        record.add("New Column");
        record.add(DBF_TYPE_CHARACTER);
        record.add(new Integer(12));
        record.add(new Integer(0));
        this.addRecord(record);
        if (this.DEBUG) {
            Debug.output("Adding record: " + record);
        }
    }

    public void exitWindowClosed() {
        if (this.source != null && this.source.dirty) {
            int check = JOptionPane.showConfirmDialog(null, "Do you want to save your changes?", "Confirm Close", 0);
            if (check == 0) {
                this.fireTableStructureChanged();
            } else {
                this.source.cleanupChanges();
            }
        }
        super.exitWindowClosed();
    }

    public void showGUI(String filename) {
        if (this.frame == null) {
            this.frame = new JFrame("Editing Attribute File Structure");
            this.frame.getContentPane().add(this.getGUI(filename, 9), "Center");
            JButton saveButton = new JButton("Save Changes");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int check = JOptionPane.showConfirmDialog(null, "Are you sure you want to modify the table format?", "Confirm Save", 2);
                    if (check == 0) {
                        MetaDbfTableModel.this.fireTableStructureChanged();
                    }
                }
            });
            this.controlPanel.add(saveButton);
            this.frame.validate();
            this.frame.setSize(500, 300);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    MetaDbfTableModel.this.exitWindowClosed();
                }
            });
        }
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            System.exit(0);
        }
        try {
            URL dbf = new URL(args[0]);
            DbfInputStream dis = new DbfInputStream(dbf.openStream());
            DbfTableModel dtm = new DbfTableModel(dis);
            MetaDbfTableModel mdtm = new MetaDbfTableModel(dtm);
            mdtm.showGUI(args[0]);
            mdtm.exitOnClose = true;
        }
        catch (Exception e) {
            Debug.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

