/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.ShpInputStream;
import com.bbn.openmap.dataAccess.shape.input.ShxInputStream;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;

public abstract class EsriGraphicList
extends OMGraphicList
implements ShapeConstants,
EsriGraphic {
    protected float[] extents;
    protected int type;

    public void add(OMGraphic shape) {
        super.add(shape);
    }

    public void addOMGraphic(OMGraphic g) {
        this.add(g);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public EsriGraphicList() {
    }

    public EsriGraphicList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriGraphicList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public void setExtents(float[] extents) {
        this.extents = extents;
    }

    public float[] getExtents() {
        if (this.extents == null) {
            this.extents = new float[]{90.0f, 180.0f, -90.0f, -180.0f};
        }
        return this.extents;
    }

    public void addExtents(float[] graphicExtents) {
        float[] ex = this.getExtents();
        for (int i = 0; i < graphicExtents.length; i += 2) {
            if (ex[0] > graphicExtents[i]) {
                ex[0] = graphicExtents[i];
            }
            if (ex[1] > graphicExtents[i + 1]) {
                ex[1] = graphicExtents[i + 1];
            }
            if (ex[2] < graphicExtents[i]) {
                ex[2] = graphicExtents[i];
            }
            if (!(ex[3] < graphicExtents[i + 1])) continue;
            ex[3] = graphicExtents[i + 1];
        }
    }

    public void setTable(DbfTableModel dtm) {
        if (dtm != null) {
            this.putAttribute("DBF_ATTRIBUTE", dtm);
        } else {
            this.removeAttribute("DBF_ATTRIBUTE");
        }
    }

    public DbfTableModel getTable() {
        Object obj = this.getAttribute("DBF_ATTRIBUTE");
        if (obj == null) {
            obj = this.getAppObject();
        }
        if (obj instanceof DbfTableModel) {
            return (DbfTableModel)obj;
        }
        return null;
    }

    public void createTable() {
        this.putAttribute("DBF_ATTRIBUTE", EsriShapeExport.createDefaultModel(this));
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, URL shx, DrawingAttributes drawingAttributes, DbfTableModel dbf) {
        return EsriGraphicList.getEsriGraphicList(shp, drawingAttributes, dbf);
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, DrawingAttributes drawingAttributes, DbfTableModel dbf) {
        EsriGraphicList list = null;
        try {
            InputStream is = shp.openStream();
            ShpInputStream pis = new ShpInputStream(is);
            if (drawingAttributes != null) {
                pis.setDrawingAttributes(drawingAttributes);
            }
            list = pis.getGeometry();
            is.close();
        }
        catch (Exception e) {
            Debug.error("EsriGraphicList: Not able to stream SHP file");
            if (!Debug.debugging("shape")) {
                // empty if block
            }
            e.printStackTrace();
            return null;
        }
        if (list != null && dbf != null && dbf.getRowCount() == list.size()) {
            list.setTable(dbf);
        }
        return list;
    }

    public static void main(String[] args) {
        String[] printit;
        String[] fixit;
        Debug.init();
        ArgParser ap = new ArgParser("EsriGraphicList");
        ap.add("fixcl", "Check and fix content length of Shape file", 1);
        ap.add("print", "Display text structure of shapes in Shape file", 1);
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        if ((fixit = ap.getArgValues("fixcl")) != null) {
            String shape = fixit[0];
            if (shape.endsWith(".shp")) {
                shape = shape.substring(0, shape.length() - 4);
                try {
                    URL shx = PropUtils.getResourceOrFileOrURL(shape + ".shx");
                    InputStream is = shx.openStream();
                    ShxInputStream pis = new ShxInputStream(is);
                    int[][] index = pis.getIndex();
                    is.close();
                    RandomAccessFile raf = new RandomAccessFile(shape + ".shp", "rw");
                    raf.seek(24L);
                    int contentLength = raf.readInt();
                    int indexedContentLength = index[0][index[0].length - 1] + index[1][index[1].length - 1];
                    if (contentLength != indexedContentLength) {
                        System.out.println(shape + " content length - shp: " + contentLength + ", shx: " + indexedContentLength);
                        raf.seek(24L);
                        raf.writeInt(indexedContentLength);
                    }
                    raf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Shape " + shape + " doesn't look like a shape file");
            }
        }
        if ((printit = ap.getArgValues("print")) != null) {
            try {
                URL eglURL = PropUtils.getResourceOrFileOrURL(printit[0]);
                EsriGraphicList egl = EsriGraphicList.getEsriGraphicList(eglURL, null, null);
                if (egl != null) {
                    System.out.println(egl.getDescription());
                }
            }
            catch (Exception e) {
                Debug.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

