/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.omGraphics.BasicStrokeEditor;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.util.ColorFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class DrawingAttributesUtility
implements ShapeConstants {
    protected DrawingAttributes da = new DrawingAttributes();
    protected int desColumn = -1;
    protected int lineColorColumn = -1;
    protected int fillColorColumn = -1;
    protected int selectColorColumn = -1;
    protected int lineWidthColumn = -1;
    protected int dashPatternColumn = -1;
    protected int dashPhaseColumn = -1;
    protected DbfTableModel model = null;
    protected DrawingAttributes defaultDA = DrawingAttributes.DEFAULT;

    protected DrawingAttributesUtility(DbfTableModel model) {
        this.model = model;
        Hashtable<String, Integer> columnNames = new Hashtable<String, Integer>();
        int numColumns = model.getColumnCount();
        for (int i = 0; i < numColumns; ++i) {
            String colName = model.getColumnName(i);
            columnNames.put(colName, new Integer(i));
        }
        Integer value = (Integer)columnNames.get("Description");
        if (value != null) {
            this.desColumn = value;
        }
        if ((value = (Integer)columnNames.get("lineColor")) != null) {
            this.lineColorColumn = value;
        }
        if ((value = (Integer)columnNames.get("fillColor")) != null) {
            this.fillColorColumn = value;
        }
        if ((value = (Integer)columnNames.get("selectColor")) != null) {
            this.selectColorColumn = value;
        }
        if ((value = (Integer)columnNames.get("lineWidth")) != null) {
            this.lineWidthColumn = value;
        }
        if ((value = (Integer)columnNames.get("dashPattern")) != null) {
            this.dashPatternColumn = value;
        }
        if ((value = (Integer)columnNames.get("dashPhase")) != null) {
            this.dashPhaseColumn = value;
        }
    }

    protected Color parseColor(String colorString, Color def) {
        Color ret;
        try {
            ret = ColorFactory.parseColor(colorString, true);
        }
        catch (NumberFormatException nfe) {
            ret = def;
        }
        return ret;
    }

    public void setDefaultAttributes(DrawingAttributes dda) {
        this.defaultDA = dda != null ? dda : DrawingAttributes.DEFAULT;
    }

    public DrawingAttributes getDefaultAttributes() {
        return this.defaultDA;
    }

    protected void configureForRecord(OMGraphic graphic, ArrayList record) {
        if (this.desColumn != -1) {
            String ret = (String)record.get(this.desColumn);
            if (graphic.getAppObject() == null) {
                graphic.setAppObject(ret);
            }
        }
        this.getDefaultAttributes().setTo(this.da);
        if (this.lineColorColumn != -1) {
            this.da.setLinePaint(this.parseColor((String)record.get(this.lineColorColumn), (Color)this.defaultDA.getLinePaint()));
        }
        if (this.fillColorColumn != -1) {
            this.da.setFillPaint(this.parseColor((String)record.get(this.fillColorColumn), (Color)this.defaultDA.getFillPaint()));
        }
        if (this.selectColorColumn != -1) {
            this.da.setSelectPaint(this.parseColor((String)record.get(this.selectColorColumn), (Color)this.defaultDA.getSelectPaint()));
        }
        int lineWidth = 1;
        float[] dashPattern = null;
        float dashPhase = 0.0f;
        if (this.lineWidthColumn != -1) {
            lineWidth = ((Double)record.get(this.lineWidthColumn)).intValue();
        }
        if (this.dashPatternColumn != -1) {
            String dp = (String)record.get(this.dashPatternColumn);
            if (dp.intern() == "") {
                dp = "No Dash Pattern";
            }
            dashPattern = BasicStrokeEditor.stringToDashArray(dp);
        }
        if (this.dashPhaseColumn != -1) {
            dashPhase = ((Double)record.get(this.lineWidthColumn)).floatValue();
        }
        this.da.setStroke(new BasicStroke(lineWidth, 0, 0, 10.0f, dashPattern, dashPhase));
        this.da.setTo(graphic);
    }

    protected void setDrawingAttributes(OMGraphic graphic, int index) {
        ArrayList record;
        if (this.model != null && (record = (ArrayList)this.model.getRecord(index)) != null) {
            this.configureForRecord(graphic, record);
        }
    }

    public static void setDrawingAttributes(EsriGraphicList list, DbfTableModel model) {
        DrawingAttributesUtility.setDrawingAttributes(list, model, DrawingAttributes.DEFAULT);
    }

    public static void setDrawingAttributes(EsriGraphicList list, DbfTableModel model, DrawingAttributes defaultDA) {
        if (list == null || model == null) {
            return;
        }
        DrawingAttributesUtility dau = new DrawingAttributesUtility(model);
        dau.setDefaultAttributes(defaultDA);
        Iterator graphics = list.iterator();
        int index = 0;
        while (graphics.hasNext()) {
            OMGraphic graphic = (OMGraphic)graphics.next();
            dau.setDrawingAttributes(graphic, index++);
        }
    }
}

