/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.dted.DTEDConstants;
import com.bbn.openmap.dataAccess.dted.DTEDFrame;
import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.GeneratorLoader;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.omGraphics.grid.SinkGenerator;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DTEDFrameCacheHandler
extends CacheHandler
implements DTEDConstants,
PropertyConsumer,
PropertyChangeListener {
    public static final String GeneratorLoadersProperty = "generators";
    protected DTEDFrameCache frameCache;
    protected double frameUp;
    protected double frameDown;
    protected double frameLeft;
    protected double frameRight;
    protected boolean firstImageReturned = true;
    protected double frameLon = 0.0;
    protected double frameLat = 0.0;
    protected boolean newframe = false;
    protected int dtedLevel = 0;
    protected GeneratorLoader activeGeneratorLoader = null;
    protected ArrayList generatorLoaders = new ArrayList();
    final JPanel cards = new JPanel(new CardLayout());
    protected String propertyPrefix = null;

    protected DTEDFrameCacheHandler() {
        this(null);
    }

    public DTEDFrameCacheHandler(DTEDFrameCache dfc) {
        this.setFrameCache(dfc);
    }

    public void setFrameCache(DTEDFrameCache dfc) {
        this.frameCache = dfc;
    }

    public DTEDFrameCache getFrameCache() {
        return this.frameCache;
    }

    public int getElevation(float lat, float lon) {
        if (this.frameCache != null) {
            return this.frameCache.getElevation(lat, lon);
        }
        return -32767;
    }

    public void setDtedLevel(int level) {
        this.dtedLevel = level;
    }

    public int getDtedLevel() {
        return this.dtedLevel;
    }

    public void setActiveGeneratorLoader(String active) {
        Iterator it = this.generatorLoaders.iterator();
        while (it.hasNext()) {
            GeneratorLoader gl = (GeneratorLoader)it.next();
            if (!active.equals(gl.getPrettyName()) || gl == this.activeGeneratorLoader) continue;
            this.activeGeneratorLoader = gl;
            this.clear();
        }
    }

    public OMGridGenerator getGenerator() {
        if (this.activeGeneratorLoader != null) {
            return this.activeGeneratorLoader.getGenerator();
        }
        return new SinkGenerator();
    }

    public Component getGUI() {
        JPanel pane = new JPanel(new BorderLayout());
        int numLoaders = this.generatorLoaders.size();
        String[] comboBoxItems = new String[numLoaders];
        int count = 0;
        Iterator it = this.generatorLoaders.iterator();
        while (it.hasNext()) {
            GeneratorLoader gl = (GeneratorLoader)it.next();
            String prettyName = gl.getPrettyName();
            comboBoxItems[count++] = prettyName;
            Component glGui = gl.getGUI();
            if (glGui == null) {
                glGui = new JLabel("No options available.");
            }
            this.cards.add(glGui, prettyName);
        }
        JComboBox<String> cb = new JComboBox<String>(comboBoxItems);
        cb.setEditable(false);
        cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CardLayout cl = (CardLayout)DTEDFrameCacheHandler.this.cards.getLayout();
                String active = (String)evt.getItem();
                cl.show(DTEDFrameCacheHandler.this.cards, active);
                DTEDFrameCacheHandler.this.setActiveGeneratorLoader(active);
            }
        });
        JPanel comboBoxPane = new JPanel();
        comboBoxPane.add(cb);
        pane.add((Component)comboBoxPane, "North");
        pane.add((Component)this.cards, "Center");
        return pane;
    }

    public OMGraphicList getRectangle(EqualArc proj) {
        float[] lat = new float[3];
        float[] lon = new float[3];
        int xa = 2;
        int ya = 2;
        int lat_minus = 2;
        int lon_minus = 2;
        LatLonPoint ll1 = proj.getUpperLeft();
        LatLonPoint ll2 = proj.getLowerRight();
        lat[0] = ll1.getLatitude();
        lon[0] = ll1.getLongitude();
        lat[1] = ll2.getLatitude();
        lon[1] = ll2.getLongitude();
        lat[2] = ll2.getLatitude();
        lon[2] = ll2.getLongitude();
        if (lon[0] > 0.0f && lon[2] < 0.0f) {
            lon[1] = -179.999f;
            lon_minus = 1;
        }
        if (lat[0] > 0.0f && lat[2] < 0.0f) {
            lat[1] = -1.0E-4f;
            lat_minus = 1;
        }
        if (Debug.debugging("dteddetail")) {
            Debug.output("For :");
            Debug.output("lat[0] " + lat[0]);
            Debug.output("lon[0] " + lon[0]);
            Debug.output("lat[1] " + lat[1]);
            Debug.output("lon[1] " + lon[1]);
            Debug.output("lat[2] " + lat[2]);
            Debug.output("lon[2] " + lon[2]);
            Debug.output("lat_minus = " + lat_minus);
            Debug.output("lon_minus = " + lon_minus);
        }
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDFrameCacheHandler: getting images: ---");
        }
        this.setProjection(proj, lat[ya - lat_minus], lon[xa - lon_minus], lat[ya], lon[xa]);
        OMGraphicList list = this.loadListFromHandler(null);
        if (lon_minus == 1) {
            this.setProjection(proj, lat[ya - lat_minus], lon[0], lat[ya], -1.0f * lon[1]);
            list = this.loadListFromHandler(list);
        }
        if (lat_minus == 1) {
            this.setProjection(proj, lat[0], lon[xa - lon_minus], -1.0f * lat[1], lon[xa]);
            list = this.loadListFromHandler(list);
        }
        if (lon_minus == 1 && lat_minus == 1) {
            this.setProjection(proj, lat[0], lon[0], -1.0f * lat[1], -1.0f * lon[1]);
            list = this.loadListFromHandler(list);
        }
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDFrameCacheHandler: finished getting images ---");
        }
        return list;
    }

    protected OMGraphicList loadListFromHandler(OMGraphicList graphics) {
        if (graphics == null) {
            graphics = new OMGraphicList();
        }
        OMGraphic image = this.getNextImage();
        while (image != null) {
            graphics.add(image);
            image = this.getNextImage();
        }
        return graphics;
    }

    public void setProjection(EqualArc proj) {
        this.setProjection(proj, proj.getUpperLeft().getLatitude(), proj.getUpperLeft().getLongitude(), proj.getLowerRight().getLatitude(), proj.getLowerRight().getLongitude());
    }

    public void setProjection(EqualArc proj, float lat1, float lon1, float lat2, float lon2) {
        this.firstImageReturned = true;
        this.frameUp = Math.floor(lat1);
        this.frameDown = Math.floor(lat2);
        this.frameLeft = Math.floor(lon1);
        this.frameRight = Math.ceil(lon2);
        if (Debug.debugging("dted")) {
            Debug.output("frameUp = " + this.frameUp + ", frameDown = " + this.frameDown + ", frameLeft = " + this.frameLeft + ", frameRight = " + this.frameRight);
        }
    }

    public OMGraphic getNextImage() {
        OMGraphic omg;
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDFrameCacheHandler: getNextImage:");
        }
        while (true) {
            if (this.firstImageReturned) {
                this.frameLon = this.frameLeft;
                this.frameLat = this.frameDown;
                this.newframe = true;
                this.firstImageReturned = false;
            } else if (this.frameLon < this.frameRight) {
                if (this.frameLat < this.frameUp) {
                    this.frameLat += 1.0;
                } else {
                    this.frameLat = this.frameDown;
                    this.frameLon += 1.0;
                }
                this.newframe = true;
            } else {
                return null;
            }
            if (!this.newframe || !(this.frameLon < this.frameRight)) continue;
            if (Debug.debugging("dted")) {
                Debug.output(" gni: Getting new frame Lat = " + this.frameLat + " Lon = " + this.frameLon);
            }
            if ((omg = this.get(this.frameLat, this.frameLon, this.dtedLevel)) != null) break;
        }
        return omg;
    }

    public OMGraphic get(double lat, double lon, int level) {
        String key = new String(lat + ":" + lon + ":" + level);
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            if (Debug.debugging("dted")) {
                Debug.output("DTEDFrameCacheHandler.get():  retrieving frame from cache (" + lat + ":" + lon + ":" + level + ")");
            }
            return (OMGraphic)ret.obj;
        }
        ret = this.load(key, lat, lon, level);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        if (Debug.debugging("dted")) {
            Debug.output("DTEDFrameCacheHandler.get():  loading new frame into cache (" + lat + ":" + lon + ":" + level + ")");
        }
        return (OMGraphic)ret.obj;
    }

    public CacheObject load(String key, double lat, double lon, int level) {
        DTEDFrame frame;
        if (this.frameCache != null && (frame = this.frameCache.get(lat, lon, level)) != null) {
            OMGrid omgrid = frame.getOMGrid();
            omgrid.setGenerator(this.getGenerator());
            return new DTEDCacheObject(key, omgrid);
        }
        return null;
    }

    public CacheObject load(String key) {
        return null;
    }

    public void setProperties(Properties props) {
        this.setProperties(this.getPropertyPrefix(), props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String generatorList = props.getProperty(realPrefix + GeneratorLoadersProperty);
        if (generatorList != null) {
            Vector generatorMarkers = PropUtils.parseSpacedMarkers(generatorList);
            Iterator it = generatorMarkers.iterator();
            while (it.hasNext()) {
                String loaderPrefix = realPrefix + (String)it.next();
                String loaderClassnameProperty = loaderPrefix + ".class";
                String classname = props.getProperty(loaderClassnameProperty);
                try {
                    GeneratorLoader loader = (GeneratorLoader)ComponentFactory.create(classname);
                    loader.setProperties(loaderPrefix, props);
                    this.generatorLoaders.add(loader);
                    loader.addPropertyChangeListener(this);
                    if (this.activeGeneratorLoader != null) continue;
                    this.activeGeneratorLoader = loader;
                }
                catch (ClassCastException cce) {
                    Debug.output("DTEDFrameCacheHandler created " + classname + ", but it's not a GeneratorLoader");
                }
                catch (NullPointerException npe) {
                    Debug.error("DTEDFrameCacheHandler:  problem creating generator loader: " + classname + " from " + loaderClassnameProperty);
                }
            }
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer sb = new StringBuffer();
        Iterator it = this.generatorLoaders.iterator();
        while (it.hasNext()) {
            GeneratorLoader gl = (GeneratorLoader)it.next();
            String pref = gl.getPropertyPrefix();
            props.put(pref + ".class", gl.getClass().getName());
            gl.getProperties(props);
            int index = pref.indexOf(prefix);
            if (index != -1) {
                pref = pref.substring(index + prefix.length());
            }
            sb.append(pref + " ");
        }
        props.put(prefix + GeneratorLoadersProperty, sb.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        this.clear();
    }

    private static class DTEDCacheObject
    extends CacheObject {
        public DTEDCacheObject(String id, OMGraphic omg) {
            super(id, omg);
        }
    }
}

