/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.BeginMetafile;
import com.bbn.openmap.dataAccess.cgm.BeginPicture;
import com.bbn.openmap.dataAccess.cgm.BeginPictureBody;
import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.CharacterHeight;
import com.bbn.openmap.dataAccess.cgm.CircleElement;
import com.bbn.openmap.dataAccess.cgm.CircularArcClosedElement;
import com.bbn.openmap.dataAccess.cgm.CircularArcElement;
import com.bbn.openmap.dataAccess.cgm.ColorSelectionMode;
import com.bbn.openmap.dataAccess.cgm.EdgeColor;
import com.bbn.openmap.dataAccess.cgm.EdgeType;
import com.bbn.openmap.dataAccess.cgm.EdgeVisibility;
import com.bbn.openmap.dataAccess.cgm.EdgeWidth;
import com.bbn.openmap.dataAccess.cgm.EdgeWidthMode;
import com.bbn.openmap.dataAccess.cgm.EllipseElement;
import com.bbn.openmap.dataAccess.cgm.EllipticalArcClosedElement;
import com.bbn.openmap.dataAccess.cgm.EllipticalArcElement;
import com.bbn.openmap.dataAccess.cgm.EndMetafile;
import com.bbn.openmap.dataAccess.cgm.EndPicture;
import com.bbn.openmap.dataAccess.cgm.FillColor;
import com.bbn.openmap.dataAccess.cgm.FontList;
import com.bbn.openmap.dataAccess.cgm.InteriorStyle;
import com.bbn.openmap.dataAccess.cgm.LineColor;
import com.bbn.openmap.dataAccess.cgm.LineType;
import com.bbn.openmap.dataAccess.cgm.LineWidth;
import com.bbn.openmap.dataAccess.cgm.LineWidthMode;
import com.bbn.openmap.dataAccess.cgm.MetafileDescription;
import com.bbn.openmap.dataAccess.cgm.MetafileElementList;
import com.bbn.openmap.dataAccess.cgm.MetafileVersion;
import com.bbn.openmap.dataAccess.cgm.PolygonElement;
import com.bbn.openmap.dataAccess.cgm.PolylineElement;
import com.bbn.openmap.dataAccess.cgm.RectangleElement;
import com.bbn.openmap.dataAccess.cgm.TextColor;
import com.bbn.openmap.dataAccess.cgm.TextElement;
import com.bbn.openmap.dataAccess.cgm.TextFontIndex;
import com.bbn.openmap.dataAccess.cgm.VDCExtent;
import java.io.DataInputStream;
import java.io.IOException;

public class Command
implements Cloneable {
    int[] args;
    int ElementClass;
    int ElementId;

    public Command(int ec, int eid, int l, DataInputStream in) throws IOException {
        this.ElementClass = ec;
        this.ElementId = eid;
        if (l != 31) {
            this.args = new int[l];
            for (int i = 0; i < l; ++i) {
                this.args[i] = in.read();
            }
            if (l % 2 == 1) {
                in.read();
            }
        } else {
            l = this.read16(in);
            this.args = new int[l];
            for (int i = 0; i < l; ++i) {
                this.args[i] = in.read();
            }
            if (l % 2 == 1) {
                in.read();
            }
        }
    }

    public int read16(DataInputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    public String toString() {
        return this.ElementClass + "," + this.ElementId + " (" + this.args.length + ")";
    }

    public String makeString() {
        if (this.args.length <= 0) {
            return "";
        }
        char[] a = new char[this.args.length - 1];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (char)this.args[i + 1];
        }
        return new String(a);
    }

    public String makeString(int k) {
        char[] a = new char[this.args[k]];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (char)this.args[k + i + 1];
        }
        return new String(a);
    }

    public int makeInt(int i) {
        return (short)(this.args[2 * i] << 8) + this.args[2 * i + 1];
    }

    public void paint(CGMDisplay d) {
    }

    public void scale(CGMDisplay d) {
    }

    public static Command read(DataInputStream in) throws IOException {
        int k = in.read();
        if (k == -1) {
            return null;
        }
        k = k << 8 | in.read();
        int ec = k >> 12;
        int eid = k >> 5 & 0x7F;
        int l = k & 0x1F;
        switch (ec) {
            case 0: {
                switch (eid) {
                    case 1: {
                        return new BeginMetafile(ec, eid, l, in);
                    }
                    case 2: {
                        return new EndMetafile(ec, eid, l, in);
                    }
                    case 3: {
                        return new BeginPicture(ec, eid, l, in);
                    }
                    case 4: {
                        return new BeginPictureBody(ec, eid, l, in);
                    }
                    case 5: {
                        return new EndPicture(ec, eid, l, in);
                    }
                }
                return new Command(ec, eid, l, in);
            }
            case 1: {
                switch (eid) {
                    case 1: {
                        return new MetafileVersion(ec, eid, l, in);
                    }
                    case 2: {
                        return new MetafileDescription(ec, eid, l, in);
                    }
                    case 11: {
                        return new MetafileElementList(ec, eid, l, in);
                    }
                    case 13: {
                        return new FontList(ec, eid, l, in);
                    }
                }
                return new Command(ec, eid, l, in);
            }
            case 2: {
                switch (eid) {
                    case 2: {
                        return new ColorSelectionMode(ec, eid, l, in);
                    }
                    case 3: {
                        return new LineWidthMode(ec, eid, l, in);
                    }
                    case 5: {
                        return new EdgeWidthMode(ec, eid, l, in);
                    }
                    case 6: {
                        return new VDCExtent(ec, eid, l, in);
                    }
                }
                return new Command(ec, eid, l, in);
            }
            case 4: {
                switch (eid) {
                    case 1: {
                        return new PolylineElement(ec, eid, l, in);
                    }
                    case 4: {
                        return new TextElement(ec, eid, l, in);
                    }
                    case 7: {
                        return new PolygonElement(ec, eid, l, in);
                    }
                    case 11: {
                        return new RectangleElement(ec, eid, l, in);
                    }
                    case 12: {
                        return new CircleElement(ec, eid, l, in);
                    }
                    case 15: {
                        return new CircularArcElement(ec, eid, l, in);
                    }
                    case 16: {
                        return new CircularArcClosedElement(ec, eid, l, in);
                    }
                    case 17: {
                        return new EllipseElement(ec, eid, l, in);
                    }
                    case 18: {
                        return new EllipticalArcElement(ec, eid, l, in);
                    }
                    case 19: {
                        return new EllipticalArcClosedElement(ec, eid, l, in);
                    }
                }
                return new Command(ec, eid, l, in);
            }
            case 5: {
                switch (eid) {
                    case 2: {
                        return new LineType(ec, eid, l, in);
                    }
                    case 3: {
                        return new LineWidth(ec, eid, l, in);
                    }
                    case 4: {
                        return new LineColor(ec, eid, l, in);
                    }
                    case 10: {
                        return new TextFontIndex(ec, eid, l, in);
                    }
                    case 14: {
                        return new TextColor(ec, eid, l, in);
                    }
                    case 15: {
                        return new CharacterHeight(ec, eid, l, in);
                    }
                    case 22: {
                        return new InteriorStyle(ec, eid, l, in);
                    }
                    case 23: {
                        return new FillColor(ec, eid, l, in);
                    }
                    case 27: {
                        return new EdgeType(ec, eid, l, in);
                    }
                    case 28: {
                        return new EdgeWidth(ec, eid, l, in);
                    }
                    case 29: {
                        return new EdgeColor(ec, eid, l, in);
                    }
                    case 30: {
                        return new EdgeVisibility(ec, eid, l, in);
                    }
                    case 40: {
                        return new EdgeType(ec, eid, l, in);
                    }
                    case 48: {
                        return new LineColor(ec, eid, l, in);
                    }
                }
                return new Command(ec, eid, l, in);
            }
        }
        return new Command(ec, eid, l, in);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }
}

