/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.ColorCommand;
import com.bbn.openmap.dataAccess.cgm.Command;
import com.bbn.openmap.dataAccess.cgm.FillColor;
import com.bbn.openmap.dataAccess.cgm.VDCExtent;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class CGM
implements Cloneable {
    protected Vector V;
    public boolean changeCGMFill = false;

    public void setChangeFill(boolean custom) {
        this.changeCGMFill = custom;
    }

    public void read(DataInputStream in) throws IOException {
        Command c;
        this.V = new Vector();
        while ((c = Command.read(in)) != null) {
            this.V.addElement(c);
        }
    }

    public void paint(CGMDisplay d) {
        Enumeration e = this.V.elements();
        while (e.hasMoreElements()) {
            Command c = (Command)e.nextElement();
            if ((c instanceof FillColor || c instanceof ColorCommand) && this.changeCGMFill) continue;
            c.paint(d);
        }
    }

    public void scale(CGMDisplay d) {
        Enumeration e = this.V.elements();
        while (e.hasMoreElements()) {
            Command c = (Command)e.nextElement();
            c.scale(d);
        }
    }

    public int[] extent() {
        Enumeration e = this.V.elements();
        while (e.hasMoreElements()) {
            Command c = (Command)e.nextElement();
            if (!(c instanceof VDCExtent)) continue;
            return ((VDCExtent)c).extent();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(args[0]));
        CGM cgm = new CGM();
        cgm.read(in);
        in.close();
    }

    public Object clone() {
        CGM newOne = new CGM();
        newOne.V = new Vector();
        for (int i = 0; i < this.V.size(); ++i) {
            newOne.V.addElement(((Command)this.V.elementAt(i)).clone());
        }
        return newOne;
    }

    public void showCGMCommands() {
        for (int i = 0; i < this.V.size(); ++i) {
            System.out.println("Command: " + (Command)this.V.elementAt(i));
        }
    }

    public void changeColor(Color oldc, Color newc) {
        for (int i = 0; i < this.V.size(); ++i) {
            Color currcolor;
            Command temp = (Command)this.V.elementAt(i);
            if (!(temp instanceof ColorCommand) || !(currcolor = ((ColorCommand)temp).C).equals(oldc)) continue;
            ((ColorCommand)temp).C = new Color(newc.getRed(), newc.getGreen(), newc.getBlue());
        }
    }
}

