/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.app;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.util.Debug;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JMenuBar;

public class OpenMapApplet
extends JApplet
implements BeanContextMembershipListener,
BeanContextChild {
    public static final String PropertiesProperty = "PROPERTIES";
    private BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);
    protected final String[][] pinfo = new String[][]{{"openmap.Latitude", "float", "Starting center latitude"}, {"openmap.Longitude", "float", "Starting center longitude"}, {"openmap.Scale", "float", "Starting Scale"}, {"openmap.Projection", "String", "Default projection type"}, {"debug.basic", "none", "enable basic debugging"}, {"openmap.HelpURL", "String", "URL location of OpenMap help pages"}};

    public String getAppletInfo() {
        return MapBean.getCopyrightMessage();
    }

    public String[][] getParameterInfo() {
        return this.pinfo;
    }

    public void init() {
        Environment.init(this);
        Debug.init(this, new String[]{"debug.basic", "debug.cspec", "debug.layer", "debug.mapbean", "debug.plugin"});
        String propValue = this.getParameter(PropertiesProperty);
        PropertyHandler propHandler = null;
        try {
            if (propValue != null) {
                propHandler = new PropertyHandler(propValue);
                if (Debug.debugging("app")) {
                    Debug.output("OpenMapApplet: Using properties from " + propValue);
                }
            }
        }
        catch (MalformedURLException murle) {
            Debug.error("OpenMap: property file specified: " + propValue + " doesn't exist, searching for default openmap.properties file...");
        }
        catch (IOException ioe) {
            Debug.error("OpenMap: There is a problem using the property file specified: " + propValue + ", searching for default openmap.properties file...");
        }
        if (propHandler == null) {
            propHandler = new PropertyHandler();
        }
        BasicMapPanel mapPanel = new BasicMapPanel(propHandler);
        mapPanel.getMapHandler().add(this);
        Debug.message("app", "OpenMapApplet.init()");
    }

    public void start() {
        Debug.message("app", "OpenMapApplet.start()");
        super.start();
    }

    public void stop() {
        Debug.message("app", "OpenMapApplet.stop()");
        super.stop();
    }

    public void destroy() {
        Debug.message("app", "OpenMapApplet.destroy()");
        super.destroy();
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Container) {
            this.getContentPane().add((Container)someObj);
            JMenuBar jmb = ((MapPanel)someObj).getMapMenuBar();
            if (jmb != null) {
                Debug.message("basic", "OpenMapApplet: Got MenuBar from MapPanel");
                this.getRootPane().setJMenuBar(jmb);
            }
            this.invalidate();
        }
        if (someObj instanceof JMenuBar) {
            this.getRootPane().setJMenuBar((JMenuBar)someObj);
            this.invalidate();
        }
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Container) {
            Debug.message("basic", "OpenMapApplet: MapPanel is being removed from applet");
            this.getContentPane().remove((Container)someObj);
            if (this.getJMenuBar() == ((MapPanel)someObj).getMapMenuBar()) {
                Debug.message("basic", "OpenMapApplet: Menu Bar is being removed");
                this.setJMenuBar(null);
            }
        }
        if (someObj instanceof JMenuBar && this.getJMenuBar() == (JMenuBar)someObj) {
            Debug.message("basic", "OpenMapApplet: MenuBar is being removed from applet");
            this.setJMenuBar(null);
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }
}

