/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.build;

import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.build.BuildServerDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class GitlabBuildServerData
extends BuildServerDataProvider {
    GitlabBuildServerData(LoggerBridge log, @NotNull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("CI");
    }

    @Override
    void loadBuildNumber(@NotNull Properties properties) {
        String uniqueBuildNumber = (String)this.env.get("CI_PIPELINE_ID");
        String buildNumber = (String)this.env.get("CI_PIPELINE_IID");
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
        this.put(properties, "build.number.unique", uniqueBuildNumber == null ? "" : uniqueBuildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("CI_COMMIT_REF_NAME");
        this.log.info("Using environment variable based branch name. CI_COMMIT_REF_NAME = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

