/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;

public class NativeGitProvider
extends GitDataProvider {
    private transient ProcessRunner runner;
    final File dotGitDirectory;
    final File canonical;
    private static final int REMOTE_COLS = 3;

    @NotNull
    public static NativeGitProvider on(@NotNull File dotGitDirectory, @NotNull LoggerBridge loggerBridge) {
        return new NativeGitProvider(dotGitDirectory, loggerBridge);
    }

    NativeGitProvider(@NotNull File dotGitDirectory, @NotNull LoggerBridge loggerBridge) {
        super(loggerBridge);
        this.dotGitDirectory = dotGitDirectory;
        try {
            this.canonical = dotGitDirectory.getCanonicalFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(new MojoExecutionException("Passed a invalid directory, not a GIT repository: " + dotGitDirectory, ex));
        }
    }

    @NotNull
    public NativeGitProvider setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    @Override
    protected void init() throws MojoExecutionException {
    }

    @Override
    protected String getBuildAuthorName() {
        try {
            return this.runGitCommand(this.canonical, "config --get user.name");
        }
        catch (NativeCommandException e) {
            if (e.getExitCode() == 1) {
                return "";
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected String getBuildAuthorEmail() {
        try {
            return this.runGitCommand(this.canonical, "config --get user.email");
        }
        catch (NativeCommandException e) {
            if (e.getExitCode() == 1) {
                return "";
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected void prepareGitToExtractMoreDetailedReproInformation() throws MojoExecutionException {
    }

    @Override
    protected String getBranchName() throws IOException {
        return this.getBranch(this.canonical);
    }

    private String getBranch(File canonical) {
        String branch = null;
        try {
            branch = this.runGitCommand(canonical, "symbolic-ref HEAD");
            if (branch != null) {
                branch = branch.replace("refs/heads/", "");
            }
        }
        catch (NativeCommandException e) {
            String err = e.getStderr();
            if (err != null && err.contains("ref HEAD is not a symbolic ref")) {
                branch = this.getCommitId();
            }
            throw Throwables.propagate((Throwable)e);
        }
        return branch;
    }

    @Override
    protected String getGitDescribe() {
        String argumentsForGitDescribe = this.getArgumentsForGitDescribe(this.gitDescribe);
        String gitDescribe = this.runQuietGitCommand(this.canonical, "describe" + argumentsForGitDescribe);
        return gitDescribe;
    }

    private String getArgumentsForGitDescribe(GitDescribeConfig describeConfig) {
        String matchOption;
        String dirtyMark;
        if (describeConfig == null) {
            return "";
        }
        StringBuilder argumentsForGitDescribe = new StringBuilder();
        if (describeConfig.isAlways()) {
            argumentsForGitDescribe.append(" --always");
        }
        if ((dirtyMark = describeConfig.getDirty()) != null && !dirtyMark.isEmpty()) {
            argumentsForGitDescribe.append(" --dirty=" + dirtyMark);
        }
        if ((matchOption = describeConfig.getMatch()) != null && !matchOption.isEmpty()) {
            argumentsForGitDescribe.append(" --match=" + matchOption);
        }
        argumentsForGitDescribe.append(" --abbrev=" + describeConfig.getAbbrev());
        if (describeConfig.getTags()) {
            argumentsForGitDescribe.append(" --tags");
        }
        if (describeConfig.getForceLongFormat()) {
            argumentsForGitDescribe.append(" --long");
        }
        return argumentsForGitDescribe.toString();
    }

    @Override
    protected String getCommitId() {
        return this.runQuietGitCommand(this.canonical, "rev-parse HEAD");
    }

    @Override
    protected String getAbbrevCommitId() {
        String commitId = this.getCommitId();
        String abbrevCommitId = "";
        if (commitId != null && !commitId.isEmpty()) {
            abbrevCommitId = commitId.substring(0, this.abbrevLength);
        }
        return abbrevCommitId;
    }

    @Override
    protected boolean isDirty() throws MojoExecutionException {
        return !this.tryCheckEmptyRunGitCommand(this.canonical, "status -s");
    }

    @Override
    protected String getCommitAuthorName() {
        return this.runQuietGitCommand(this.canonical, "log -1 --pretty=format:%an");
    }

    @Override
    protected String getCommitAuthorEmail() {
        return this.runQuietGitCommand(this.canonical, "log -1 --pretty=format:%ae");
    }

    @Override
    protected String getCommitMessageFull() {
        return this.runQuietGitCommand(this.canonical, "log -1 --pretty=format:%B");
    }

    @Override
    protected String getCommitMessageShort() {
        return this.runQuietGitCommand(this.canonical, "log -1 --pretty=format:%s");
    }

    @Override
    protected String getCommitTime() {
        String value = this.runQuietGitCommand(this.canonical, "log -1 --pretty=format:%ct");
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(Long.parseLong(value) * 1000L);
    }

    @Override
    protected String getTags() {
        String result = this.runQuietGitCommand(this.canonical, "tag --contains");
        return result.replace('\n', ',');
    }

    @Override
    protected String getRemoteOriginUrl() throws MojoExecutionException {
        return this.getOriginRemote(this.canonical);
    }

    @Override
    protected String getClosestTagName() {
        try {
            return this.runGitCommand(this.canonical, "describe --abbrev=0 --tags");
        }
        catch (NativeCommandException nativeCommandException) {
            return "";
        }
    }

    @Override
    protected String getClosestTagCommitCount() {
        String closestTagName = this.getClosestTagName();
        if (closestTagName != null && !closestTagName.trim().isEmpty()) {
            return this.runQuietGitCommand(this.canonical, "rev-list " + closestTagName + "..HEAD --count");
        }
        return "";
    }

    @Override
    protected void finalCleanUp() {
    }

    private String getOriginRemote(File directory) throws MojoExecutionException {
        String remoteUrl = null;
        String remotes = this.runQuietGitCommand(directory, "remote -v");
        for (String line : Splitter.onPattern((String)"\\((fetch|push)\\)?").split((CharSequence)remotes)) {
            String trimmed = line.trim();
            if (!trimmed.startsWith("origin")) continue;
            String[] splited = trimmed.split("\\s+");
            if (splited.length != 2) {
                throw new MojoExecutionException("Unsupported GIT output (verbose remote address): " + line);
            }
            remoteUrl = splited[1];
        }
        return remoteUrl;
    }

    private boolean tryCheckEmptyRunGitCommand(File directory, String gitCommand) {
        try {
            String env = System.getenv("GIT_PATH");
            String exec = env == null ? "git" : env;
            String command = String.format("%s %s", exec, gitCommand);
            return this.getRunner().runEmpty(directory, command);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private String runQuietGitCommand(File directory, String gitCommand) {
        String env = System.getenv("GIT_PATH");
        String exec = env == null ? "git" : env;
        String command = String.format("%s %s", exec, gitCommand);
        try {
            return this.getRunner().run(directory, command.trim()).trim();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String runGitCommand(File directory, String gitCommand) throws NativeCommandException {
        String env = System.getenv("GIT_PATH");
        String exec = env == null ? "git" : env;
        String command = String.format("%s %s", exec, gitCommand);
        try {
            return this.getRunner().run(directory, command.trim()).trim();
        }
        catch (NativeCommandException e) {
            throw e;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ProcessRunner getRunner() {
        if (this.runner == null) {
            this.runner = new JavaProcessRunner();
        }
        return this.runner;
    }

    protected static class JavaProcessRunner
    implements ProcessRunner {
        protected JavaProcessRunner() {
        }

        @Override
        public String run(File directory, String command) throws IOException {
            String output = "";
            try {
                String line;
                ProcessBuilder builder = new ProcessBuilder(command.split("\\s"));
                Process proc = builder.directory(directory).start();
                proc.waitFor();
                InputStream is = proc.getInputStream();
                InputStream err = proc.getErrorStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder commandResult = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    commandResult.append(line).append("\n");
                }
                if (proc.exitValue() != 0) {
                    StringBuilder errMsg = this.readStderr(err);
                    throw new NativeCommandException(proc.exitValue(), command, directory, output, errMsg.toString());
                }
                output = commandResult.toString();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            return output;
        }

        private StringBuilder readStderr(InputStream err) throws IOException {
            String line;
            BufferedReader errReader = new BufferedReader(new InputStreamReader(err));
            StringBuilder errMsg = new StringBuilder();
            while ((line = errReader.readLine()) != null) {
                errMsg.append(line);
            }
            return errMsg;
        }

        @Override
        public boolean runEmpty(File directory, String command) throws IOException {
            boolean empty = true;
            try {
                ProcessBuilder builder = new ProcessBuilder(Lists.asList((Object)"/bin/sh", (Object)"-c", (Object[])command.split("\\s")));
                Process proc = builder.directory(directory).start();
                proc.waitFor();
                InputStream is = proc.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                if (reader.readLine() != null) {
                    empty = false;
                }
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            return empty;
        }
    }

    public static class NativeCommandException
    extends IOException {
        private final int exitCode;
        private final String command;
        private final File directory;
        private final String stdout;
        private final String stderr;

        public NativeCommandException(int exitCode, String command, File directory, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.command = command;
            this.directory = directory;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getCommand() {
            return this.command;
        }

        public File getDirectory() {
            return this.directory;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        @Override
        public String getMessage() {
            return String.format("Git command exited with invalid status [%d]: stdout: `%s`, stderr: `%s`", this.exitCode, this.stdout, this.stderr);
        }
    }

    public static interface ProcessRunner {
        public String run(File var1, String var2) throws IOException;

        public boolean runEmpty(File var1, String var2) throws IOException;
    }
}

