/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.zkoss.util.logging.Log;

public class HibernateUtil {
    private static final Log log = Log.lookup((Class)HibernateUtil.class);
    private static SessionFactory _factory;

    public static SessionFactory getSessionFactory() {
        return HibernateUtil.initSessionFactory();
    }

    public static Session currentSession() throws HibernateException {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }

    public static void closeSession() throws HibernateException {
        HibernateUtil.currentSession().close();
    }

    static SessionFactory initSessionFactory() {
        if (_factory == null) {
            try {
                _factory = new Configuration().configure().buildSessionFactory();
            }
            catch (Throwable ex) {
                log.error("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        return _factory;
    }

    static void cleanupSessionFactory() {
        if (_factory != null) {
            _factory.close();
            _factory = null;
        }
    }
}

