/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import org.xBaseJ.indexes.NodeKey;

public class BinaryTree {
    private BinaryTree lesser = null;
    private BinaryTree greater = null;
    private BinaryTree above = null;
    private NodeKey key;
    private int where;

    NodeKey getKey() {
        return this.key;
    }

    int getWhere() {
        return this.where;
    }

    private void setLesser(BinaryTree inTree) {
        this.lesser = inTree;
    }

    private void setGreater(BinaryTree inTree) {
        this.greater = inTree;
    }

    public BinaryTree(NodeKey inkey, int inWhere, BinaryTree top) {
        this.key = inkey;
        this.where = inWhere;
        if (top != null) {
            this.above = top.findPos(this.key);
            if (this.above.getKey().compareKey(inkey) > 0) {
                this.above.setLesser(this);
            } else {
                this.above.setGreater(this);
            }
        }
    }

    private BinaryTree findPos(NodeKey inkey) {
        if (this.key.compareKey(inkey) > 0) {
            if (this.lesser == null) {
                return this;
            }
            return this.lesser.findPos(inkey);
        }
        if (this.greater == null) {
            return this;
        }
        return this.greater.findPos(inkey);
    }

    public BinaryTree getLeast() {
        if (this.lesser != null) {
            return this.lesser.getLeast();
        }
        return this;
    }

    public BinaryTree getNext() {
        if (this.greater == null) {
            if (this.above == null) {
                return null;
            }
            return this.above.goingUp(this.key);
        }
        return this.greater.getLeast();
    }

    private BinaryTree goingUp(NodeKey inKey) {
        if (this.key.compareKey(inKey) <= 0) {
            if (this.above == null) {
                return null;
            }
            return this.above.goingUp(this.key);
        }
        return this;
    }
}

