/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddSecurityDomain
implements OnlineCommand,
OfflineCommand {
    private final String securityDomainName;
    private final String cacheType;
    private final boolean replaceExisting;

    private AddSecurityDomain(Builder builder) {
        this.securityDomainName = builder.securityDomainName;
        this.cacheType = builder.cacheType;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws CliException, CommandFailedException, IOException, TimeoutException, InterruptedException {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Operations ops = new Operations(ctx.client);
        Address securityDomainAddress = Address.subsystem((String)"security").and("security-domain", this.securityDomainName);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(securityDomainAddress);
                new Administration(ctx.client).reloadIfRequired();
            }
            catch (OperationException e) {
                throw new IOException("Failed to remove existing security domain " + this.securityDomainName, e);
            }
        }
        ops.add(securityDomainAddress, Values.empty().andOptional("cache-type", this.cacheType));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddSecurityDomain.class).subtree("securitySubsystem", Subtree.subsystem("security")).parameter("atrSecurityDomainName", this.securityDomainName).parameter("atrCacheType", this.cacheType).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder {
        private String securityDomainName;
        private String cacheType;
        private boolean replaceExisting;

        public Builder(String securityDomainName) {
            if (securityDomainName == null) {
                throw new IllegalArgumentException("Name of the security-domain must be specified as non null value");
            }
            if (securityDomainName.isEmpty()) {
                throw new IllegalArgumentException("Name of the security-domain must not be empty value");
            }
            this.securityDomainName = securityDomainName;
        }

        public Builder cacheType(String cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddSecurityDomain build() {
            return new AddSecurityDomain(this);
        }
    }
}

