angular.module('textAngular.validators', [])
.directive('taMaxText', function(){
    return {
        restrict: 'A',
        require: 'ngModel',
        link: function(scope, elem, attrs, ctrl){
            var max = parseInt(scope.$eval(attrs.taMaxText));
            if (isNaN(max)){
                throw('Max text must be an integer');
            }
            attrs.$observe('taMaxText', function(value){
                max = parseInt(value);
                if (isNaN(max)){
                    throw('Max text must be an integer');
                }
                if (ctrl.$dirty){
                    ctrl.$validate();
                }
            });
            ctrl.$validators.taMaxText = function(viewValue){
                var source = angular.element('<div/>');
                source.html(viewValue);
                return source.text().length <= max;
            };
        }
    };
}).directive('taMinText', function(){
    return {
        restrict: 'A',
        require: 'ngModel',
        link: function(scope, elem, attrs, ctrl){
            var min = parseInt(scope.$eval(attrs.taMinText));
            if (isNaN(min)){
                throw('Min text must be an integer');
            }
            attrs.$observe('taMinText', function(value){
                min = parseInt(value);
                if (isNaN(min)){
                    throw('Min text must be an integer');
                }
                if (ctrl.$dirty){
                    ctrl.$validate();
                }
            });
            ctrl.$validators.taMinText = function(viewValue){
                var source = angular.element('<div/>');
                source.html(viewValue);
                return !source.text().length || source.text().length >= min;
            };
        }
    };
});