/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.util;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public class ContextClassLoaderApplicationContextHolder {
    private static final ConcurrentHashMap<ClassLoader, ApplicationContext> contextMap = new ConcurrentHashMap();

    public static ApplicationContext get() {
        for (ClassLoader classLoader = ContextClassLoaderApplicationContextHolder.getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            ApplicationContext applicationContext = contextMap.get(classLoader);
            if (applicationContext == null) continue;
            return applicationContext;
        }
        return null;
    }

    public static void bind(ApplicationContext context) {
        ApplicationContext old = contextMap.putIfAbsent(ContextClassLoaderApplicationContextHolder.getContextClassLoader(), context);
        if (old != null) {
            throw new IllegalStateException("There is already a ApplicationContext associated with the context ClassLoader of the current thread!");
        }
    }

    public static void release() {
        contextMap.remove(ContextClassLoaderApplicationContextHolder.getContextClassLoader());
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Unable to get the context class loader for the current thread!");
        }
        return classLoader;
    }
}

