/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.property.PropertyFeatureMetaData;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.util.NamedFeature;

public class PropertyFeatureProvider
implements FeatureProvider {
    private final Set<Feature> features = new LinkedHashSet<Feature>();
    private final Map<String, FeatureMetaData> metadata = new HashMap<String, FeatureMetaData>();

    public PropertyFeatureProvider(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            String spec = entry.getValue().toString();
            NamedFeature feature = new NamedFeature(name);
            this.features.add(feature);
            this.metadata.put(name, new PropertyFeatureMetaData(feature, spec));
        }
    }

    @Override
    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    @Override
    public FeatureMetaData getMetaData(Feature feature) {
        return this.metadata.get(feature.name());
    }
}

