/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.result.condition.MediaTypeExpression;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

abstract class AbstractMediaTypeExpression
implements Comparable<AbstractMediaTypeExpression>,
MediaTypeExpression {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final MediaType mediaType;
    private final boolean isNegated;

    AbstractMediaTypeExpression(String expression) {
        if (expression.startsWith("!")) {
            this.isNegated = true;
            expression = expression.substring(1);
        } else {
            this.isNegated = false;
        }
        this.mediaType = MediaType.parseMediaType((String)expression);
    }

    AbstractMediaTypeExpression(MediaType mediaType, boolean negated) {
        this.mediaType = mediaType;
        this.isNegated = negated;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    public final boolean match(ServerWebExchange exchange) {
        try {
            boolean match = this.matchMediaType(exchange);
            return !this.isNegated == match;
        }
        catch (NotAcceptableStatusException ex) {
            return false;
        }
        catch (UnsupportedMediaTypeStatusException ex) {
            return false;
        }
    }

    protected abstract boolean matchMediaType(ServerWebExchange var1) throws NotAcceptableStatusException, UnsupportedMediaTypeStatusException;

    @Override
    public int compareTo(AbstractMediaTypeExpression other) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(this.getMediaType(), other.getMediaType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            AbstractMediaTypeExpression other = (AbstractMediaTypeExpression)obj;
            return this.mediaType.equals((Object)other.mediaType) && this.isNegated == other.isNegated;
        }
        return false;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isNegated) {
            builder.append('!');
        }
        builder.append(this.mediaType.toString());
        return builder.toString();
    }
}

