/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import org.springframework.core.SpringProperties;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.util.StringUtils;

public abstract class ContextCacheUtils {
    public static int retrieveMaxCacheSize() {
        String propertyName = "spring.test.context.cache.maxSize";
        int defaultValue = 32;
        return ContextCacheUtils.retrieveProperty(propertyName, defaultValue);
    }

    public static int retrieveContextFailureThreshold() {
        String propertyName = "spring.test.context.failure.threshold";
        int defaultValue = 1;
        return ContextCacheUtils.retrieveProperty(propertyName, defaultValue);
    }

    public static ContextCache.PauseMode retrievePauseMode() {
        String value = SpringProperties.getProperty((String)"spring.test.context.cache.pause");
        if (StringUtils.hasText((String)value)) {
            ContextCache.PauseMode pauseMode = ContextCache.PauseMode.from(value);
            if (pauseMode == null) {
                throw new IllegalArgumentException("Unsupported value '%s' for property '%s'".formatted(value, "spring.test.context.cache.pause"));
            }
            return pauseMode;
        }
        return ContextCache.PauseMode.ON_CONTEXT_SWITCH;
    }

    private static int retrieveProperty(String key, int defaultValue) {
        try {
            String value = SpringProperties.getProperty((String)key);
            if (StringUtils.hasText((String)value)) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

