/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.OptimisticLockException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    private static Class<?> optimisticLockExceptionClass;
    private static Class<?> pessimisticLockExceptionClass;
    private boolean prepareConnection = HibernateConnectionHandle.access$000() == null;

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        Session session = this.getSession(entityManager);
        if (definition.getTimeout() != -1) {
            session.getTransaction().setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        boolean resetConnection = false;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            if (this.prepareConnection) {
                Connection con = HibernateConnectionHandle.doGetConnection(session);
                previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
                resetConnection = true;
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException(this.getClass().getSimpleName() + " does not support custom isolation levels since the 'prepareConnection' flag is off. " + "This is the case on Hibernate 3.6 by default; either switch that flag at your own risk " + "or upgrade to Hibernate 4.x, with 4.2+ recommended.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode(session, definition.isReadOnly());
        return new SessionTransactionData(session, previousFlushMode, resetConnection, previousIsolationLevel);
    }

    @Override
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, String name) throws PersistenceException {
        Session session = this.getSession(entityManager);
        FlushMode previousFlushMode = this.prepareFlushMode(session, readOnly);
        return new SessionTransactionData(session, previousFlushMode, false, null);
    }

    protected FlushMode prepareFlushMode(Session session, boolean readOnly) throws PersistenceException {
        FlushMode flushMode = session.getFlushMode();
        if (readOnly) {
            if (!flushMode.equals(FlushMode.MANUAL)) {
                session.setFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    @Override
    public void cleanupTransaction(Object transactionData) {
        ((SessionTransactionData)transactionData).resetSessionState();
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Session session = this.getSession(entityManager);
        return new HibernateConnectionHandle(session);
    }

    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)((Object)ex));
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof org.hibernate.QueryTimeoutException) {
            org.hibernate.QueryTimeoutException jdbcEx = (org.hibernate.QueryTimeoutException)ex;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            PessimisticLockException jdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            DataException jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof QueryException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            UnresolvableObjectException hibEx = (UnresolvableObjectException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof WrongClassException) {
            WrongClassException hibEx = (WrongClassException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            StaleObjectStateException hibEx = (StaleObjectStateException)ex;
            return new ObjectOptimisticLockingFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), (Throwable)ex);
        }
        if (ex instanceof StaleStateException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (optimisticLockExceptionClass.isInstance((Object)ex)) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (pessimisticLockExceptionClass != null && pessimisticLockExceptionClass.isInstance((Object)ex)) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new JpaSystemException((RuntimeException)((Object)ex));
    }

    protected Session getSession(EntityManager entityManager) {
        return (Session)entityManager.unwrap(Session.class);
    }

    static {
        ClassLoader cl = HibernateJpaDialect.class.getClassLoader();
        try {
            optimisticLockExceptionClass = cl.loadClass("org.hibernate.dialect.lock.OptimisticEntityLockException");
        }
        catch (ClassNotFoundException ex) {
            optimisticLockExceptionClass = OptimisticLockException.class;
        }
        try {
            pessimisticLockExceptionClass = cl.loadClass("org.hibernate.dialect.lock.PessimisticEntityLockException");
        }
        catch (ClassNotFoundException ex) {
            pessimisticLockExceptionClass = null;
        }
    }

    private static class HibernateConnectionHandle
    implements ConnectionHandle {
        private static final Method sessionConnectionMethod;
        private static volatile Method connectionMethodToUse;
        private final Session session;

        public HibernateConnectionHandle(Session session) {
            this.session = session;
        }

        public Connection getConnection() {
            return HibernateConnectionHandle.doGetConnection(this.session);
        }

        public void releaseConnection(Connection con) {
            if (sessionConnectionMethod != null) {
                JdbcUtils.closeConnection((Connection)con);
            }
        }

        public static Connection doGetConnection(Session session) {
            try {
                if (connectionMethodToUse == null) {
                    connectionMethodToUse = session.getClass().getMethod("connection", new Class[0]);
                }
                return (Connection)ReflectionUtils.invokeMethod((Method)connectionMethodToUse, (Object)session);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Cannot find connection() method on Hibernate Session", ex);
            }
        }

        static /* synthetic */ Method access$000() {
            return sessionConnectionMethod;
        }

        static {
            connectionMethodToUse = sessionConnectionMethod = ClassUtils.getMethodIfAvailable(Session.class, (String)"connection", (Class[])new Class[0]);
        }
    }

    private static class SessionTransactionData {
        private final Session session;
        private final FlushMode previousFlushMode;
        private final boolean resetConnection;
        private final Integer previousIsolationLevel;

        public SessionTransactionData(Session session, FlushMode previousFlushMode, boolean resetConnection, Integer previousIsolationLevel) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
            this.resetConnection = resetConnection;
            this.previousIsolationLevel = previousIsolationLevel;
        }

        public void resetSessionState() {
            if (this.previousFlushMode != null) {
                this.session.setFlushMode(this.previousFlushMode);
            }
            if (this.resetConnection && this.session.isConnected()) {
                Connection con = HibernateConnectionHandle.doGetConnection(this.session);
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)this.previousIsolationLevel);
            }
        }
    }
}

