/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class AsyncResult<V>
implements ListenableFuture<V> {
    private final V value;
    private final ExecutionException executionException;

    public AsyncResult(V value) {
        this(value, null);
    }

    private AsyncResult(V value, ExecutionException ex) {
        this.value = value;
        this.executionException = ex;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    public V get() throws ExecutionException {
        if (this.executionException != null) {
            throw this.executionException;
        }
        return this.value;
    }

    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        return this.get();
    }

    public void addCallback(ListenableFutureCallback<? super V> callback) {
        this.addCallback((SuccessCallback<? super V>)callback, (FailureCallback)callback);
    }

    public void addCallback(SuccessCallback<? super V> successCallback, FailureCallback failureCallback) {
        try {
            successCallback.onSuccess(this.value);
        }
        catch (Throwable ex) {
            failureCallback.onFailure(ex);
        }
    }

    public static <V> ListenableFuture<V> forValue(V value) {
        return new AsyncResult<V>(value, null);
    }

    public static <V> ListenableFuture<V> forExecutionException(Throwable ex) {
        return new AsyncResult<Object>(null, ex instanceof ExecutionException ? (ExecutionException)ex : new ExecutionException(ex));
    }
}

