/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheFactoryBean
implements FactoryBean<Ehcache>,
BeanNameAware,
InitializingBean {
    private static final boolean setStatisticsAvailable = ClassUtils.hasMethod(Ehcache.class, (String)"setStatisticsEnabled", (Class[])new Class[]{Boolean.TYPE});
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private String cacheName;
    private int maxElementsInMemory = 10000;
    private int maxElementsOnDisk = 10000000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    private boolean overflowToDisk = true;
    private boolean eternal = false;
    private int timeToLive = 120;
    private int timeToIdle = 120;
    private boolean diskPersistent = false;
    private int diskExpiryThreadIntervalSeconds = 120;
    private int diskSpoolBufferSize = 0;
    private boolean clearOnFlush = true;
    private boolean blocking = false;
    private CacheEntryFactory cacheEntryFactory;
    private BootstrapCacheLoader bootstrapCacheLoader;
    private Set<CacheEventListener> cacheEventListeners;
    private boolean statisticsEnabled = false;
    private boolean sampledStatisticsEnabled = false;
    private boolean disabled = false;
    private String beanName;
    private Ehcache cache;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        Assert.notNull((Object)memoryStoreEvictionPolicy, (String)"memoryStoreEvictionPolicy must not be null");
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToIdle(int timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setDiskSpoolBufferSize(int diskSpoolBufferSize) {
        this.diskSpoolBufferSize = diskSpoolBufferSize;
    }

    public void setClearOnFlush(boolean clearOnFlush) {
        this.clearOnFlush = clearOnFlush;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCacheEntryFactory(CacheEntryFactory cacheEntryFactory) {
        this.cacheEntryFactory = cacheEntryFactory;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) {
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setCacheEventListeners(Set<CacheEventListener> cacheEventListeners) {
        this.cacheEventListeners = cacheEventListeners;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setSampledStatisticsEnabled(boolean sampledStatisticsEnabled) {
        this.sampledStatisticsEnabled = sampledStatisticsEnabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws CacheException, IOException {
        if (this.cacheManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using default EhCache CacheManager for cache region '" + this.cacheName + "'"));
            }
            this.cacheManager = CacheManager.getInstance();
        }
        if (this.cacheName == null) {
            this.cacheName = this.beanName;
        }
        CacheManager cacheManager = this.cacheManager;
        synchronized (cacheManager) {
            Ehcache decoratedCache;
            Cache rawCache;
            boolean cacheExists = this.cacheManager.cacheExists(this.cacheName);
            if (cacheExists) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using existing EhCache cache region '" + this.cacheName + "'"));
                }
                rawCache = this.cacheManager.getEhcache(this.cacheName);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating new EhCache cache region '" + this.cacheName + "'"));
                }
                rawCache = this.createCache();
            }
            if (this.cacheEventListeners != null) {
                for (CacheEventListener listener : this.cacheEventListeners) {
                    rawCache.getCacheEventNotificationService().registerListener(listener);
                }
            }
            if (!cacheExists) {
                this.cacheManager.addCache((Ehcache)rawCache);
            }
            if (setStatisticsAvailable) {
                if (this.statisticsEnabled) {
                    rawCache.setStatisticsEnabled(true);
                }
                if (this.sampledStatisticsEnabled) {
                    rawCache.setSampledStatisticsEnabled(true);
                }
            }
            if (this.disabled) {
                rawCache.setDisabled(true);
            }
            if ((decoratedCache = this.decorateCache((Ehcache)rawCache)) != rawCache) {
                this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)rawCache, decoratedCache);
            }
            this.cache = decoratedCache;
        }
    }

    protected Cache createCache() {
        return !this.clearOnFlush ? new Cache(this.cacheName, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, null, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null, this.bootstrapCacheLoader, this.maxElementsOnDisk, this.diskSpoolBufferSize, this.clearOnFlush) : new Cache(this.cacheName, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, null, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null, this.bootstrapCacheLoader, this.maxElementsOnDisk, this.diskSpoolBufferSize);
    }

    protected Ehcache decorateCache(Ehcache cache) {
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return new UpdatingSelfPopulatingCache(cache, (UpdatingCacheEntryFactory)this.cacheEntryFactory);
            }
            return new SelfPopulatingCache(cache, this.cacheEntryFactory);
        }
        if (this.blocking) {
            return new BlockingCache(cache);
        }
        return cache;
    }

    public Ehcache getObject() {
        return this.cache;
    }

    public Class<? extends Ehcache> getObjectType() {
        if (this.cache != null) {
            return this.cache.getClass();
        }
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return UpdatingSelfPopulatingCache.class;
            }
            return SelfPopulatingCache.class;
        }
        if (this.blocking) {
            return BlockingCache.class;
        }
        return Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

