/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.connect;

import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookServiceProvider
extends AbstractOAuth2ServiceProvider<Facebook> {
    private String appNamespace;
    private static final String API_VERSION = "2.5";
    private static final String GRAPH_API_URL = "https://graph.facebook.com/v2.5/";

    public FacebookServiceProvider(String appId, String appSecret, String appNamespace) {
        super((OAuth2Operations)FacebookServiceProvider.getOAuth2Template(appId, appSecret));
        this.appNamespace = appNamespace;
    }

    private static OAuth2Template getOAuth2Template(String appId, String appSecret) {
        OAuth2Template oAuth2Template = new OAuth2Template(appId, appSecret, "https://www.facebook.com/v2.5/dialog/oauth", "https://graph.facebook.com/v2.5/oauth/access_token");
        oAuth2Template.setUseParametersForClientAuthentication(true);
        return oAuth2Template;
    }

    public Facebook getApi(String accessToken) {
        return new FacebookTemplate(accessToken, this.appNamespace);
    }
}

