/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.config.web.server.ServerSecurityMarker;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.IpAddressReactiveAuthorizationManager;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import reactor.core.publisher.Mono;

@ServerSecurityMarker
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003+,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0019\u001a\u00020\u000fJ%\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001c\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001f\u001a\u00020\u000fJ%\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001c\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010#\u001a\u00020\u000fJ\u001d\u0010&\u001a\u0012\u0012\b\u0012\u00060(R\u00020)\u0012\u0004\u0012\u00020\b0'H\u0000\u00a2\u0006\u0002\b*R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015\u00a8\u0006."}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl;", "", "<init>", "()V", "authorizationRules", "", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "authorize", "", "matcher", "Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "access", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "antPattern", "", "anyExchange", "getAnyExchange", "()Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "permitAll", "getPermitAll", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "denyAll", "getDenyAll", "hasRole", "role", "hasAnyRole", "roles", "", "([Ljava/lang/String;)Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "hasAuthority", "authority", "hasAnyAuthority", "authorities", "hasIpAddress", "ipAddress", "authenticated", "getAuthenticated", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/web/server/ServerHttpSecurity$AuthorizeExchangeSpec;", "Lorg/springframework/security/config/web/server/ServerHttpSecurity;", "get$spring_security_config", "MatcherExchangeAuthorizationRule", "PatternExchangeAuthorizationRule", "ExchangeAuthorizationRule", "spring-security-config"})
@SourceDebugExtension(value={"SMAP\nAuthorizeExchangeDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizeExchangeDsl.kt\norg/springframework/security/config/web/server/AuthorizeExchangeDsl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1869#2,2:146\n*S KotlinDebug\n*F\n+ 1 AuthorizeExchangeDsl.kt\norg/springframework/security/config/web/server/AuthorizeExchangeDsl\n*L\n127#1:146,2\n*E\n"})
public final class AuthorizeExchangeDsl {
    @NotNull
    private final List<ExchangeAuthorizationRule> authorizationRules = new ArrayList();
    @NotNull
    private final ServerWebExchangeMatcher anyExchange;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> permitAll;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> denyAll;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> authenticated;

    public AuthorizeExchangeDsl() {
        ServerWebExchangeMatcher serverWebExchangeMatcher = ServerWebExchangeMatchers.anyExchange();
        Intrinsics.checkNotNullExpressionValue((Object)serverWebExchangeMatcher, (String)"anyExchange(...)");
        this.anyExchange = serverWebExchangeMatcher;
        this.permitAll = AuthorizeExchangeDsl::permitAll$lambda$0;
        this.denyAll = AuthorizeExchangeDsl::denyAll$lambda$0;
        AuthenticatedReactiveAuthorizationManager authenticatedReactiveAuthorizationManager = AuthenticatedReactiveAuthorizationManager.authenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedReactiveAuthorizationManager, (String)"authenticated(...)");
        this.authenticated = (ReactiveAuthorizationManager)authenticatedReactiveAuthorizationManager;
    }

    public final void authorize(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new MatcherExchangeAuthorizationRule(matcher, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeExchangeDsl authorizeExchangeDsl, ServerWebExchangeMatcher serverWebExchangeMatcher, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
        if ((n & 1) != 0) {
            ServerWebExchangeMatcher serverWebExchangeMatcher2 = ServerWebExchangeMatchers.anyExchange();
            Intrinsics.checkNotNullExpressionValue((Object)serverWebExchangeMatcher2, (String)"anyExchange(...)");
            serverWebExchangeMatcher = serverWebExchangeMatcher2;
        }
        if ((n & 2) != 0) {
            reactiveAuthorizationManager = authorizeExchangeDsl.authenticated;
        }
        authorizeExchangeDsl.authorize(serverWebExchangeMatcher, reactiveAuthorizationManager);
    }

    public final void authorize(@NotNull String antPattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)antPattern, (String)"antPattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new PatternExchangeAuthorizationRule(antPattern, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeExchangeDsl authorizeExchangeDsl, String string, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
        if ((n & 2) != 0) {
            reactiveAuthorizationManager = authorizeExchangeDsl.authenticated;
        }
        authorizeExchangeDsl.authorize(string, reactiveAuthorizationManager);
    }

    @NotNull
    public final ServerWebExchangeMatcher getAnyExchange() {
        return this.anyExchange;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasRole((String)role);
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"hasRole(...)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAnyRole((String[])Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"hasAnyRole(...)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAuthority((String)authority);
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"hasAuthority(...)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAnyAuthority((String[])Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"hasAnyAuthority(...)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasIpAddress(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        IpAddressReactiveAuthorizationManager ipAddressReactiveAuthorizationManager = IpAddressReactiveAuthorizationManager.hasIpAddress((String)ipAddress);
        Intrinsics.checkNotNullExpressionValue((Object)ipAddressReactiveAuthorizationManager, (String)"hasIpAddress(...)");
        return (ReactiveAuthorizationManager)ipAddressReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final Function1<ServerHttpSecurity.AuthorizeExchangeSpec, Unit> get$spring_security_config() {
        return arg_0 -> AuthorizeExchangeDsl.get$lambda$0(this, arg_0);
    }

    private static final Mono permitAll$lambda$0(Mono mono, AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)mono, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"<unused var>");
        return Mono.just((Object)new AuthorizationDecision(true));
    }

    private static final Mono denyAll$lambda$0(Mono mono, AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)mono, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"<unused var>");
        return Mono.just((Object)new AuthorizationDecision(false));
    }

    private static final Unit get$lambda$0(AuthorizeExchangeDsl this$0, ServerHttpSecurity.AuthorizeExchangeSpec requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Iterable $this$forEach$iv = this$0.authorizationRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray;
            ExchangeAuthorizationRule rule = (ExchangeAuthorizationRule)element$iv;
            boolean bl = false;
            ExchangeAuthorizationRule exchangeAuthorizationRule = rule;
            if (exchangeAuthorizationRule instanceof MatcherExchangeAuthorizationRule) {
                objectArray = new ServerWebExchangeMatcher[]{((MatcherExchangeAuthorizationRule)rule).getMatcher()};
                ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)requests.matchers((ServerWebExchangeMatcher[])objectArray)).access(((MatcherExchangeAuthorizationRule)rule).getRule());
                continue;
            }
            if (!(exchangeAuthorizationRule instanceof PatternExchangeAuthorizationRule)) continue;
            objectArray = new String[]{((PatternExchangeAuthorizationRule)rule).getPattern()};
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)requests.pathMatchers((String[])objectArray)).access(((PatternExchangeAuthorizationRule)rule).getRule());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "<init>", "(Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "spring-security-config"})
    private static abstract class ExchangeAuthorizationRule {
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        public ExchangeAuthorizationRule(@NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            this.rule = rule;
        }

        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$MatcherExchangeAuthorizationRule;", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "matcher", "Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "<init>", "(Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getMatcher", "()Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "spring-security-config"})
    private static final class MatcherExchangeAuthorizationRule
    extends ExchangeAuthorizationRule {
        @NotNull
        private final ServerWebExchangeMatcher matcher;
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        public MatcherExchangeAuthorizationRule(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            super(rule);
            this.matcher = matcher;
            this.rule = rule;
        }

        @NotNull
        public final ServerWebExchangeMatcher getMatcher() {
            return this.matcher;
        }

        @Override
        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }

        @NotNull
        public final ServerWebExchangeMatcher component1() {
            return this.matcher;
        }

        @NotNull
        public final ReactiveAuthorizationManager<AuthorizationContext> component2() {
            return this.rule;
        }

        @NotNull
        public final MatcherExchangeAuthorizationRule copy(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            return new MatcherExchangeAuthorizationRule(matcher, rule);
        }

        public static /* synthetic */ MatcherExchangeAuthorizationRule copy$default(MatcherExchangeAuthorizationRule matcherExchangeAuthorizationRule, ServerWebExchangeMatcher serverWebExchangeMatcher, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
            if ((n & 1) != 0) {
                serverWebExchangeMatcher = matcherExchangeAuthorizationRule.matcher;
            }
            if ((n & 2) != 0) {
                reactiveAuthorizationManager = matcherExchangeAuthorizationRule.rule;
            }
            return matcherExchangeAuthorizationRule.copy(serverWebExchangeMatcher, reactiveAuthorizationManager);
        }

        @NotNull
        public String toString() {
            return "MatcherExchangeAuthorizationRule(matcher=" + this.matcher + ", rule=" + this.rule + ")";
        }

        public int hashCode() {
            int result = this.matcher.hashCode();
            result = result * 31 + this.rule.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatcherExchangeAuthorizationRule)) {
                return false;
            }
            MatcherExchangeAuthorizationRule matcherExchangeAuthorizationRule = (MatcherExchangeAuthorizationRule)other;
            if (!Intrinsics.areEqual((Object)this.matcher, (Object)matcherExchangeAuthorizationRule.matcher)) {
                return false;
            }
            return Intrinsics.areEqual(this.rule, matcherExchangeAuthorizationRule.rule);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$PatternExchangeAuthorizationRule;", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "pattern", "", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "<init>", "(Ljava/lang/String;Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getPattern", "()Ljava/lang/String;", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "spring-security-config"})
    private static final class PatternExchangeAuthorizationRule
    extends ExchangeAuthorizationRule {
        @NotNull
        private final String pattern;
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        public PatternExchangeAuthorizationRule(@NotNull String pattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            super(rule);
            this.pattern = pattern;
            this.rule = rule;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        @NotNull
        public final ReactiveAuthorizationManager<AuthorizationContext> component2() {
            return this.rule;
        }

        @NotNull
        public final PatternExchangeAuthorizationRule copy(@NotNull String pattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            return new PatternExchangeAuthorizationRule(pattern, rule);
        }

        public static /* synthetic */ PatternExchangeAuthorizationRule copy$default(PatternExchangeAuthorizationRule patternExchangeAuthorizationRule, String string, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
            if ((n & 1) != 0) {
                string = patternExchangeAuthorizationRule.pattern;
            }
            if ((n & 2) != 0) {
                reactiveAuthorizationManager = patternExchangeAuthorizationRule.rule;
            }
            return patternExchangeAuthorizationRule.copy(string, reactiveAuthorizationManager);
        }

        @NotNull
        public String toString() {
            return "PatternExchangeAuthorizationRule(pattern=" + this.pattern + ", rule=" + this.rule + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + this.rule.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatternExchangeAuthorizationRule)) {
                return false;
            }
            PatternExchangeAuthorizationRule patternExchangeAuthorizationRule = (PatternExchangeAuthorizationRule)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)patternExchangeAuthorizationRule.pattern)) {
                return false;
            }
            return Intrinsics.areEqual(this.rule, patternExchangeAuthorizationRule.rule);
        }
    }
}

