/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authorization;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration(proxyBeanMethods=false)
class EnableMfaFiltersConfiguration {
    EnableMfaFiltersConfiguration() {
    }

    @Bean
    BeanPostProcessor mfaBeanPostProcessor() {
        return new EnableMfaFiltersPostProcessor();
    }

    private static class EnableMfaFiltersPostProcessor
    implements BeanPostProcessor {
        private EnableMfaFiltersPostProcessor() {
        }

        public @Nullable Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            AbstractAuthenticationProcessingFilter filter;
            if (bean instanceof AbstractAuthenticationProcessingFilter) {
                filter = (AbstractAuthenticationProcessingFilter)bean;
                filter.setMfaEnabled(true);
            }
            if (bean instanceof AuthenticationFilter) {
                filter = (AuthenticationFilter)bean;
                filter.setMfaEnabled(true);
            }
            if (bean instanceof AbstractPreAuthenticatedProcessingFilter) {
                filter = (AbstractPreAuthenticatedProcessingFilter)bean;
                filter.setMfaEnabled(true);
            }
            if (bean instanceof BasicAuthenticationFilter) {
                filter = (BasicAuthenticationFilter)bean;
                filter.setMfaEnabled(true);
            }
            return bean;
        }
    }
}

