/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ConsumerPostProcessor;
import org.springframework.kafka.core.KafkaResourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultKafkaConsumerFactory<K, V>
extends KafkaResourceFactory
implements ConsumerFactory<K, V>,
BeanNameAware,
ApplicationContextAware {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(DefaultKafkaConsumerFactory.class));
    private final Map<String, Object> configs;
    private final List<ConsumerFactory.Listener<K, V>> listeners = new ArrayList<ConsumerFactory.Listener<K, V>>();
    private final List<ConsumerPostProcessor<K, V>> postProcessors = new ArrayList<ConsumerPostProcessor<K, V>>();
    private Supplier<Deserializer<K>> keyDeserializerSupplier;
    private Supplier<Deserializer<V>> valueDeserializerSupplier;
    private String beanName = "not.managed.by.Spring";
    private boolean configureDeserializers = true;
    private ApplicationContext applicationContext;

    public DefaultKafkaConsumerFactory(Map<String, Object> configs) {
        this(configs, () -> null, () -> null);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer) {
        this(configs, () -> keyDeserializer, () -> valueDeserializer);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer, boolean configureDeserializers) {
        this(configs, () -> keyDeserializer, () -> valueDeserializer, configureDeserializers);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Supplier<Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<Deserializer<V>> valueDeserializerSupplier) {
        this(configs, keyDeserializerSupplier, valueDeserializerSupplier, true);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Supplier<Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<Deserializer<V>> valueDeserializerSupplier, boolean configureDeserializers) {
        this.configs = new ConcurrentHashMap<String, Object>(configs);
        this.configureDeserializers = configureDeserializers;
        this.keyDeserializerSupplier = keyDeserializerSupplier;
        this.valueDeserializerSupplier = valueDeserializerSupplier;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        this.keyDeserializerSupplier = () -> keyDeserializer;
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        this.valueDeserializerSupplier = () -> valueDeserializer;
    }

    public void setKeyDeserializerSupplier(Supplier<Deserializer<K>> keyDeserializerSupplier) {
        this.keyDeserializerSupplier = keyDeserializerSupplier;
    }

    public void setValueDeserializerSupplier(Supplier<Deserializer<V>> valueDeserializerSupplier) {
        this.valueDeserializerSupplier = valueDeserializerSupplier;
    }

    public void setConfigureDeserializers(boolean configureDeserializers) {
        this.configureDeserializers = configureDeserializers;
    }

    @Override
    public Map<String, Object> getConfigurationProperties() {
        HashMap<String, Object> configs2 = new HashMap<String, Object>(this.configs);
        this.checkBootstrap(configs2);
        return Collections.unmodifiableMap(configs2);
    }

    @Override
    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializerSupplier.get();
    }

    @Override
    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializerSupplier.get();
    }

    @Override
    public List<ConsumerFactory.Listener<K, V>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public List<ConsumerPostProcessor<K, V>> getPostProcessors() {
        return Collections.unmodifiableList(this.postProcessors);
    }

    @Override
    public void addListener(ConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public void addListener(int index, ConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        if (index >= this.listeners.size()) {
            this.listeners.add(listener);
        } else {
            this.listeners.add(index, listener);
        }
    }

    @Override
    public void addPostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
        Assert.notNull(postProcessor, (String)"'postProcessor' cannot be null");
        this.postProcessors.add(postProcessor);
    }

    @Override
    public boolean removePostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
        return this.postProcessors.remove(postProcessor);
    }

    @Override
    public boolean removeListener(ConsumerFactory.Listener<K, V> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void updateConfigs(Map<String, Object> updates) {
        this.configs.putAll(updates);
    }

    @Override
    public void removeConfig(String configKey) {
        this.configs.remove(configKey);
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffixArg, properties);
    }

    protected Consumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefixArg, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        boolean shouldModifyClientId;
        String applicationName;
        boolean hasGroupIdOrClientIdInConfig;
        boolean overrideClientIdPrefix = StringUtils.hasText((String)clientIdPrefixArg);
        Object clientIdPrefix = clientIdPrefixArg;
        String clientIdSuffix = clientIdSuffixArg;
        if (clientIdPrefix == null) {
            clientIdPrefix = "";
        }
        if (clientIdSuffix == null) {
            clientIdSuffix = "";
        }
        boolean hasGroupIdOrClientIdInProperties = properties != null && (properties.containsKey("client.id") || properties.containsKey("group.id"));
        boolean bl = hasGroupIdOrClientIdInConfig = this.configs.containsKey("client.id") || this.configs.containsKey("group.id");
        if (!(overrideClientIdPrefix || groupId != null || hasGroupIdOrClientIdInProperties || hasGroupIdOrClientIdInConfig || (applicationName = (String)Optional.ofNullable(this.applicationContext).map(EnvironmentCapable::getEnvironment).map(environment -> environment.getProperty("spring.application.name")).orElse(null)) == null)) {
            clientIdPrefix = applicationName + "-consumer";
            overrideClientIdPrefix = true;
        }
        boolean bl2 = shouldModifyClientId = this.configs.containsKey("client.id") && StringUtils.hasText((String)clientIdSuffix) || overrideClientIdPrefix;
        if (groupId == null && (properties == null || properties.stringPropertyNames().isEmpty()) && !shouldModifyClientId) {
            return this.createKafkaConsumer(new HashMap<String, Object>(this.configs));
        }
        return this.createConsumerWithAdjustedProperties(groupId, (String)clientIdPrefix, properties, overrideClientIdPrefix, clientIdSuffix, shouldModifyClientId);
    }

    private Consumer<K, V> createConsumerWithAdjustedProperties(@Nullable String groupId, String clientIdPrefix, @Nullable Properties properties, boolean overrideClientIdPrefix, String clientIdSuffix, boolean shouldModifyClientId) {
        HashMap<String, Object> modifiedConfigs = new HashMap<String, Object>(this.configs);
        if (groupId != null) {
            modifiedConfigs.put("group.id", groupId);
        }
        if (shouldModifyClientId) {
            modifiedConfigs.put("client.id", (overrideClientIdPrefix ? clientIdPrefix : modifiedConfigs.get("client.id")) + clientIdSuffix);
        }
        if (properties != null) {
            Set<String> stringPropertyNames = properties.stringPropertyNames();
            stringPropertyNames.stream().filter(name -> !name.equals("client.id") && !name.equals("group.id")).forEach(name -> modifiedConfigs.put((String)name, properties.getProperty((String)name)));
            properties.entrySet().stream().filter(entry -> !entry.getKey().equals("client.id") && !entry.getKey().equals("group.id") && !stringPropertyNames.contains(entry.getKey()) && entry.getKey() instanceof String).forEach(entry -> modifiedConfigs.put((String)entry.getKey(), entry.getValue()));
            this.checkInaccessible(properties, modifiedConfigs);
        }
        return this.createKafkaConsumer(modifiedConfigs);
    }

    private void checkInaccessible(Properties properties, Map<String, Object> modifiedConfigs) {
        ArrayList inaccessible = null;
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object nextElement = propertyNames.nextElement();
            if (modifiedConfigs.containsKey(nextElement)) continue;
            if (inaccessible == null) {
                inaccessible = new ArrayList();
            }
            inaccessible.add(nextElement);
        }
        if (inaccessible != null) {
            LOGGER.error((CharSequence)("Non-String-valued default properties are inaccessible; use String values or make them explicit properties instead of defaults: " + inaccessible));
        }
    }

    protected Consumer<K, V> createKafkaConsumer(Map<String, Object> configProps) {
        this.checkBootstrap(configProps);
        Consumer kafkaConsumer = this.createRawConsumer(configProps);
        if (!this.listeners.isEmpty() && !(kafkaConsumer instanceof ExtendedKafkaConsumer)) {
            LOGGER.warn((CharSequence)"The 'ConsumerFactory.Listener' configuration is ignored because the consumer is not an instance of 'ExtendedKafkaConsumer'.Consider extending 'ExtendedKafkaConsumer' or implement your own 'ConsumerFactory'.");
        }
        for (ConsumerPostProcessor<K, V> pp : this.postProcessors) {
            kafkaConsumer = (Consumer)pp.apply(kafkaConsumer);
        }
        return kafkaConsumer;
    }

    protected Consumer<K, V> createRawConsumer(Map<String, Object> configProps) {
        return new ExtendedKafkaConsumer(configProps);
    }

    @Override
    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : !(auto instanceof String) || Boolean.parseBoolean((String)auto);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Nullable
    private Deserializer<K> keyDeserializer(Map<String, Object> configs) {
        Deserializer<K> deserializer;
        Deserializer<K> deserializer2 = deserializer = this.keyDeserializerSupplier != null ? this.keyDeserializerSupplier.get() : null;
        if (deserializer != null && this.configureDeserializers) {
            deserializer.configure(configs, true);
        }
        return deserializer;
    }

    @Nullable
    private Deserializer<V> valueDeserializer(Map<String, Object> configs) {
        Deserializer<V> deserializer;
        Deserializer<V> deserializer2 = deserializer = this.valueDeserializerSupplier != null ? this.valueDeserializerSupplier.get() : null;
        if (deserializer != null && this.configureDeserializers) {
            deserializer.configure(configs, false);
        }
        return deserializer;
    }

    protected class ExtendedKafkaConsumer
    extends KafkaConsumer<K, V> {
        private String idForListeners;

        protected ExtendedKafkaConsumer(Map<String, Object> configProps) {
            super(configProps, DefaultKafkaConsumerFactory.this.keyDeserializer(configProps), DefaultKafkaConsumerFactory.this.valueDeserializer(configProps));
            if (!DefaultKafkaConsumerFactory.this.listeners.isEmpty()) {
                Iterator metricIterator = this.metrics().keySet().iterator();
                String clientId = "unknown";
                if (metricIterator.hasNext()) {
                    clientId = (String)((MetricName)metricIterator.next()).tags().get("client-id");
                }
                this.idForListeners = DefaultKafkaConsumerFactory.this.beanName + "." + clientId;
                for (ConsumerFactory.Listener listener : DefaultKafkaConsumerFactory.this.listeners) {
                    listener.consumerAdded(this.idForListeners, this);
                }
            }
        }

        public void close() {
            super.close();
            this.notifyConsumerRemoved();
        }

        public void close(Duration timeout) {
            super.close(timeout);
            this.notifyConsumerRemoved();
        }

        private void notifyConsumerRemoved() {
            for (ConsumerFactory.Listener listener : DefaultKafkaConsumerFactory.this.listeners) {
                listener.consumerRemoved(this.idForListeners, this);
            }
        }
    }
}

