/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Message;
import javax.mail.Store;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.event.MailIntegrationEvent;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.IntegrationResourceHolderSynchronization;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ImapIdleChannelAdapter
extends MessageProducerSupport
implements BeanClassLoaderAware,
ApplicationEventPublisherAware {
    private final IdleTask idleTask = new IdleTask();
    private volatile Executor sendingTaskExecutor;
    private volatile boolean sendingTaskExecutorSet;
    private volatile boolean shouldReconnectAutomatically = true;
    private volatile ClassLoader classLoader;
    private volatile List<Advice> adviceChain;
    private final ImapMailReceiver mailReceiver;
    private volatile int reconnectDelay = 10000;
    private volatile ScheduledFuture<?> receivingTask;
    private volatile ScheduledFuture<?> pingTask;
    private volatile long connectionPingInterval = 10000L;
    private final ExceptionAwarePeriodicTrigger receivingTaskTrigger = new ExceptionAwarePeriodicTrigger();
    private volatile TransactionSynchronizationFactory transactionSynchronizationFactory;
    private volatile ApplicationEventPublisher applicationEventPublisher;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"'mailReceiver' must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setSendingTaskExecutor(Executor sendingTaskExecutor) {
        Assert.notNull((Object)sendingTaskExecutor, (String)"'sendingTaskExecutor' must not be null");
        this.sendingTaskExecutor = sendingTaskExecutor;
        this.sendingTaskExecutorSet = true;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        if (this.sendingTaskExecutor == null) {
            this.sendingTaskExecutor = Executors.newFixedThreadPool(1);
        }
        this.receivingTask = scheduler.schedule((Runnable)new ReceivingTask(), (Trigger)this.receivingTaskTrigger);
        this.pingTask = scheduler.scheduleAtFixedRate((Runnable)new PingTask(), this.connectionPingInterval);
    }

    protected void doStop() {
        this.receivingTask.cancel(true);
        this.pingTask.cancel(true);
        try {
            this.mailReceiver.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure during the destruction of Mail receiver: " + this.mailReceiver, e);
        }
        if (!this.sendingTaskExecutorSet && this.sendingTaskExecutor != null) {
            ((ExecutorService)this.sendingTaskExecutor).shutdown();
            this.sendingTaskExecutor = null;
        }
    }

    private Runnable createMessageSendingTask(final Message mailMessage) {
        Runnable sendingTask = new Runnable(){

            @Override
            public void run() {
                org.springframework.messaging.Message message = ImapIdleChannelAdapter.this.getMessageBuilderFactory().withPayload((Object)mailMessage).build();
                if (TransactionSynchronizationManager.isActualTransactionActive() && ImapIdleChannelAdapter.this.transactionSynchronizationFactory != null) {
                    TransactionSynchronization synchronization = ImapIdleChannelAdapter.this.transactionSynchronizationFactory.create((Object)ImapIdleChannelAdapter.this);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                    if (synchronization instanceof IntegrationResourceHolderSynchronization) {
                        IntegrationResourceHolder holder = ((IntegrationResourceHolderSynchronization)synchronization).getResourceHolder();
                        holder.setMessage(message);
                    }
                }
                ImapIdleChannelAdapter.this.sendMessage(message);
            }
        };
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)sendingTask);
            if (!CollectionUtils.isEmpty(this.adviceChain)) {
                for (Advice advice : this.adviceChain) {
                    proxyFactory.addAdvice(advice);
                }
            }
            sendingTask = (Runnable)proxyFactory.getProxy(this.classLoader);
        }
        return sendingTask;
    }

    private void publishException(Exception e) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImapIdleExceptionEvent(e));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No application event publisher for exception: " + e.getMessage()));
        }
    }

    public class ImapIdleExceptionEvent
    extends MailIntegrationEvent {
        private static final long serialVersionUID = -5875388810251967741L;

        public ImapIdleExceptionEvent(Exception e) {
            super((Object)ImapIdleChannelAdapter.this, e);
        }
    }

    private class ExceptionAwarePeriodicTrigger
    implements Trigger {
        private volatile boolean delayNextExecution;

        private ExceptionAwarePeriodicTrigger() {
        }

        public Date nextExecutionTime(TriggerContext triggerContext) {
            if (this.delayNextExecution) {
                this.delayNextExecution = false;
                return new Date(System.currentTimeMillis() + (long)ImapIdleChannelAdapter.this.reconnectDelay);
            }
            return new Date(System.currentTimeMillis());
        }

        public void delayNextExecution() {
            this.delayNextExecution = true;
        }
    }

    private class PingTask
    implements Runnable {
        private PingTask() {
        }

        @Override
        public void run() {
            try {
                Store store = ImapIdleChannelAdapter.this.mailReceiver.getStore();
                if (store != null) {
                    store.isConnected();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class IdleTask
    implements Runnable {
        private IdleTask() {
        }

        @Override
        public void run() {
            TaskScheduler scheduler = ImapIdleChannelAdapter.this.getTaskScheduler();
            Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
            Assert.state((ImapIdleChannelAdapter.this.sendingTaskExecutor != null ? 1 : 0) != 0, (String)"'sendingTaskExecutor' must not be null");
            try {
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                }
                ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                if (ImapIdleChannelAdapter.this.mailReceiver.getFolder().isOpen()) {
                    Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    for (Message mailMessage : mailMessages) {
                        Runnable messageSendingTask = ImapIdleChannelAdapter.this.createMessageSendingTask(mailMessage);
                        ImapIdleChannelAdapter.this.sendingTaskExecutor.execute(messageSendingTask);
                    }
                }
            }
            catch (javax.mail.MessagingException e) {
                if (ImapIdleChannelAdapter.this.logger.isWarnEnabled()) {
                    ImapIdleChannelAdapter.this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
                }
                if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                    throw new IllegalStateException("Failure in 'idle' task. Will resubmit.", e);
                }
                throw new MessagingException("Failure in 'idle' task. Will NOT resubmit.", (Throwable)e);
            }
        }
    }

    private class ReceivingTask
    implements Runnable {
        private ReceivingTask() {
        }

        @Override
        public void run() {
            try {
                ImapIdleChannelAdapter.this.idleTask.run();
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"Task completed successfully. Re-scheduling it again right away.");
                }
            }
            catch (Exception e) {
                ImapIdleChannelAdapter.this.logger.warn((Object)("Failed to execute IDLE task. Will attempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds."), (Throwable)e);
                ImapIdleChannelAdapter.this.receivingTaskTrigger.delayNextExecution();
                ImapIdleChannelAdapter.this.publishException(e);
            }
        }
    }
}

