/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.expression;

import java.util.Optional;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SmartEnvironmentAccessor
implements PropertyAccessor {
    @NonNull
    public static SmartEnvironmentAccessor create() {
        return new SmartEnvironmentAccessor();
    }

    @Nullable
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Environment.class, EnvironmentCapable.class};
    }

    private Optional<Environment> asEnvironment(@Nullable Object target) {
        Environment environment = target instanceof Environment ? (Environment)target : (target instanceof EnvironmentCapable ? ((EnvironmentCapable)target).getEnvironment() : null);
        return Optional.ofNullable(environment);
    }

    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
        return this.asEnvironment(target).filter(environment -> environment.containsProperty(name)).isPresent();
    }

    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
        String value = this.asEnvironment(target).map(environment -> environment.getProperty(name)).orElse(null);
        return new TypedValue((Object)value);
    }

    public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) {
    }
}

