/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io.support;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.geode.core.io.ResourceNotFoundException;
import org.springframework.geode.core.io.ResourceResolver;
import org.springframework.geode.core.io.support.ResourceUtils;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ResourceLoaderResourceResolver
implements ResourceLoaderAware,
ResourceResolver {
    private final AtomicReference<ResourceLoader> resolvedResourceLoader = new AtomicReference<Object>(null);

    @Override
    public Optional<ClassLoader> getClassLoader() {
        return Optional.ofNullable(Optional.ofNullable(this.resolvedResourceLoader.get()).map(ResourceLoader::getClassLoader).orElseGet(ClassUtils::getDefaultClassLoader));
    }

    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resolvedResourceLoader.set(resourceLoader);
    }

    @NonNull
    protected ResourceLoader getResourceLoader() {
        return this.resolvedResourceLoader.updateAndGet(resourceLoader -> ObjectUtils.initialize(resourceLoader, this::newResourceLoader));
    }

    @NonNull
    protected ResourceLoader newResourceLoader() {
        return (ResourceLoader)this.getClassLoader().map(DefaultResourceLoader::new).orElseGet(DefaultResourceLoader::new);
    }

    @NonNull
    protected Resource newResource(@NonNull String location) {
        Assert.hasText((String)location, () -> String.format("The location [%s] of the Resource must be specified", location));
        return new ClassPathResource(location);
    }

    protected boolean isQualified(@Nullable Resource resource) {
        return resource != null;
    }

    @Nullable
    protected Resource onMissingResource(@Nullable Resource resource, @NonNull String location) {
        throw new ResourceNotFoundException(String.format("Failed to resolve Resource [%1$s] at location [%2$s]", ResourceUtils.nullSafeGetDescription(resource), location));
    }

    protected Resource postProcess(Resource resource) {
        return resource;
    }

    @Override
    public Optional<Resource> resolve(@NonNull String location) {
        Assert.hasText((String)location, () -> String.format("The location [%s] of the Resource to resolve must be specified", location));
        Resource resource = this.getResourceLoader().getResource(location);
        resource = this.postProcess(resource);
        Resource resolvedResource = this.isQualified(resource) ? resource : this.onMissingResource(resource, location);
        return Optional.ofNullable(resolvedResource);
    }
}

