/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io;

import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.geode.core.io.ResourceNotFoundException;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface ResourceResolver {
    default public Optional<ClassLoader> getClassLoader() {
        return Optional.ofNullable(ClassUtils.getDefaultClassLoader());
    }

    public Optional<Resource> resolve(@NonNull String var1);

    @NonNull
    default public Resource require(@NonNull String location) {
        return this.resolve(location).filter(Resource::exists).orElseThrow(() -> new ResourceNotFoundException(String.format("Resource [%s] does not exist", location)));
    }
}

