/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.context.logging;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EnvironmentLoggingApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    protected static final String SYSTEM_ERR_ENABLED_PROPERTY = "spring.context.environment.logging.system-err.enabled";
    static final ThreadLocal<Environment> threadLocalEnvironmentReference = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(@NonNull ContextRefreshedEvent contextRefreshedEvent) {
        Environment environment = contextRefreshedEvent.getApplicationContext().getEnvironment();
        threadLocalEnvironmentReference.set(environment);
        try {
            this.log("ENV: [%s]", ObjectUtils.nullSafeClassName((Object)environment));
            this.log("ENV: Active Profiles %s", Arrays.toString(environment.getActiveProfiles()));
            this.log("ENV: Default Profiles %s", Arrays.toString(environment.getDefaultProfiles()));
            if (environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
                for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
                    this.log("ENV: PropertySource [%s]", propertySource.getName());
                    this.getCompositePropertySourceLoggingFunction().apply(propertySource);
                }
            }
        }
        finally {
            threadLocalEnvironmentReference.remove();
        }
    }

    protected Function<PropertySource<?>, PropertySource<?>> getCompositePropertySourceLoggingFunction() {
        return new EnumerablePropertySourceLoggingFunction().andThen(new MapPropertySourceLoggingFunction());
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    protected void log(String message, Object ... args) {
        if (StringUtils.hasText((String)message)) {
            this.logToSlf4jLogger(message, args);
            this.logToSystemErr(message, args);
        }
    }

    void logToSlf4jLogger(String message, Object ... args) {
        this.getLogger().debug(String.format(message, args));
    }

    void logToSystemErr(String message, Object ... args) {
        if (this.isSystemErrLoggingEnabled()) {
            message = message.trim().endsWith("%n") ? message : message.concat("%n");
            System.err.printf(message, args);
            System.err.flush();
        }
    }

    private boolean isSystemErrLoggingEnabled() {
        return Optional.ofNullable(threadLocalEnvironmentReference.get()).map(environment -> (Boolean)environment.getProperty(SYSTEM_ERR_ENABLED_PROPERTY, Boolean.class, (Object)false)).orElseGet(() -> Boolean.getBoolean(SYSTEM_ERR_ENABLED_PROPERTY));
    }

    protected class MapPropertySourceLoggingFunction
    extends AbstractPropertySourceLoggingFunction {
        protected MapPropertySourceLoggingFunction() {
        }

        @Override
        @Nullable
        public PropertySource<?> apply(@Nullable PropertySource<?> propertySource) {
            if (!(propertySource instanceof EnumerablePropertySource)) {
                Object source;
                Object object = source = propertySource != null ? propertySource.getSource() : null;
                if (source instanceof Map) {
                    TreeMap map = new TreeMap((Map)source);
                    this.logProperties(map.keySet(), map::get);
                }
            }
            return propertySource;
        }
    }

    protected class EnumerablePropertySourceLoggingFunction
    extends AbstractPropertySourceLoggingFunction {
        protected EnumerablePropertySourceLoggingFunction() {
        }

        @Override
        @Nullable
        public PropertySource<?> apply(@Nullable PropertySource<?> propertySource) {
            if (propertySource instanceof EnumerablePropertySource) {
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                Object[] propertyNames = enumerablePropertySource.getPropertyNames();
                Arrays.sort(propertyNames);
                this.logProperties(Arrays.asList(propertyNames), arg_0 -> ((EnumerablePropertySource)enumerablePropertySource).getProperty(arg_0));
            }
            return propertySource;
        }
    }

    protected abstract class AbstractPropertySourceLoggingFunction
    implements Function<PropertySource<?>, PropertySource<?>> {
        protected AbstractPropertySourceLoggingFunction() {
        }

        protected void logProperties(@NonNull Iterable<String> propertyNames, @NonNull Function<String, Object> propertyValueFunction) {
            EnvironmentLoggingApplicationListener.this.log("Properties [", new Object[0]);
            for (String propertyName : CollectionUtils.nullSafeIterable(propertyNames)) {
                EnvironmentLoggingApplicationListener.this.log("\t%1$s = %2$s", propertyName, propertyValueFunction.apply(propertyName));
            }
            EnvironmentLoggingApplicationListener.this.log("]", new Object[0]);
        }
    }
}

