/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.function.Supplier;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.data.util.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class ParameterBindingContext {
    private final ValueProvider valueProvider;
    private final SpelExpressionParser expressionParser;
    private final Lazy<EvaluationContext> evaluationContext;

    @Deprecated
    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, EvaluationContext evaluationContext) {
        this(valueProvider, expressionParser, () -> evaluationContext);
    }

    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, Supplier<EvaluationContext> evaluationContext) {
        this.valueProvider = valueProvider;
        this.expressionParser = expressionParser;
        this.evaluationContext = evaluationContext instanceof Lazy ? (Lazy)evaluationContext : Lazy.of(evaluationContext);
    }

    @Nullable
    public Object bindableValueForIndex(int index) {
        return this.valueProvider.getBindableValue(index);
    }

    @Nullable
    public Object evaluateExpression(String expressionString) {
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(this.getEvaluationContext(), Object.class);
    }

    public EvaluationContext getEvaluationContext() {
        return (EvaluationContext)this.evaluationContext.get();
    }

    public SpelExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

