/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleKeyValueRepository<T, ID>
implements KeyValueRepository<T, ID> {
    private final KeyValueOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleKeyValueRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations) {
        Assert.notNull(metadata, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)operations, (String)"KeyValueOperations must not be null!");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public Iterable<T> findAll(Sort sort) {
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.entityInformation.getJavaType());
        return new PageImpl(IterableConverter.toList(content), pageable, this.operations.count(this.entityInformation.getJavaType()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            this.operations.insert(entity);
        } else {
            this.operations.update(this.entityInformation.getRequiredId(entity), entity);
        }
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        entities.forEach(this::save);
        return entities;
    }

    public Optional<T> findById(ID id) {
        return this.operations.findById(id, this.entityInformation.getJavaType());
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public List<T> findAll() {
        return IterableConverter.toList(this.operations.findAll(this.entityInformation.getJavaType()));
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        ArrayList result = new ArrayList();
        ids.forEach(id -> this.findById(id).ifPresent(result::add));
        return result;
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void deleteById(ID id) {
        this.operations.delete(id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        this.deleteById(this.entityInformation.getRequiredId(entity));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }
}

