/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.antlr.v4.runtime.tree.ParseTree;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryRenderer;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.jpa.repository.query.QueryTransformers;
import org.springframework.util.StringUtils;

class EqlCountQueryTransformer
extends EqlQueryRenderer {
    @Nullable
    private final String countProjection;
    @Nullable
    private final String primaryFromAlias;

    EqlCountQueryTransformer(@Nullable String countProjection, QueryInformation queryInformation) {
        this.countProjection = countProjection;
        this.primaryFromAlias = queryInformation.getAlias();
    }

    @Override
    public QueryTokenStream visitSelectQuery(EqlParser.SelectQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromQuery(EqlParser.FromQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder countBuilder = QueryRenderer.builder();
        countBuilder.append(QueryTokens.TOKEN_SELECT_COUNT);
        if (this.countProjection != null) {
            countBuilder.append(QueryTokens.token(this.countProjection));
        } else if (this.primaryFromAlias == null) {
            countBuilder.append(QueryTokens.TOKEN_DOUBLE_UNDERSCORE);
        } else {
            countBuilder.append(QueryTokens.token(this.primaryFromAlias));
        }
        countBuilder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.appendExpression(countBuilder);
        if (ctx.from_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
            if (this.primaryFromAlias == null) {
                builder.append(QueryTokens.TOKEN_AS);
                builder.append(QueryTokens.TOKEN_DOUBLE_UNDERSCORE);
            }
        }
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        boolean usesDistinct = ctx.DISTINCT() != null;
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        builder.append(QueryTokens.TOKEN_COUNT_FUNC);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (this.countProjection == null) {
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
                nested.append(this.getDistinctCountSelection(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((EqlCountQueryTransformer)this).visit(arg_0), QueryTokens.TOKEN_COMMA)));
            } else if (StringUtils.hasText((String)this.primaryFromAlias)) {
                nested.append(QueryTokens.token(this.primaryFromAlias));
            } else if (ctx.select_item().isEmpty()) {
                nested.append(QueryTokens.token("1"));
            } else {
                nested.append((QueryTokenStream)this.visit((ParseTree)ctx.select_item().get(0)));
            }
        } else {
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            nested.append(QueryTokens.token(this.countProjection));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    private QueryTokenStream getDistinctCountSelection(QueryTokenStream selectionListbuilder) {
        QueryRenderer.QueryRendererBuilder nested = new QueryRenderer.QueryRendererBuilder();
        QueryTransformers.CountSelectionTokenStream countSelection = QueryTransformers.CountSelectionTokenStream.create(selectionListbuilder);
        if (countSelection.requiresPrimaryAlias()) {
            if (this.primaryFromAlias == null) {
                throw new IllegalStateException("Primary alias must be set for DISTINCT count selection using constructor expressions");
            }
            nested.append(QueryTokens.token(this.primaryFromAlias));
        } else {
            nested.append(countSelection);
        }
        return nested;
    }
}

