/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.aot.generate.AotRepositoryBeanDefinitionPropertiesDecorator;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.LocalVariableNameFactory;
import org.springframework.data.repository.aot.generate.VariableNameFactory;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeName;
import org.springframework.util.Assert;

class RepositoryConstructorBuilder
implements AotRepositoryConstructorBuilder {
    private final String beanFactory = AotRepositoryBeanDefinitionPropertiesDecorator.RESERVED_TYPES.get(ResolvableType.forClass(BeanFactory.class));
    private final String fragmentCreationContext = AotRepositoryBeanDefinitionPropertiesDecorator.RESERVED_TYPES.get(ResolvableType.forClass(RepositoryFactoryBeanSupport.FragmentCreationContext.class));
    private final AotRepositoryFragmentMetadata metadata;
    private final Set<String> parametersAdded = new LinkedHashSet<String>();
    private final Map<String, String> localVariables = new LinkedHashMap<String, String>();
    private final VariableNameFactory variableNameFactory;
    private AotRepositoryConstructorBuilder.ConstructorCustomizer customizer = builder -> builder.addStatement("super(%s%s)".formatted("$L".repeat(this.parametersAdded.isEmpty() ? 0 : 1), ", $L".repeat(Math.max(0, this.parametersAdded.size() - 1))), this.parametersAdded.toArray());

    RepositoryConstructorBuilder(AotRepositoryFragmentMetadata metadata) {
        this.metadata = metadata;
        this.variableNameFactory = new LocalVariableNameFactory(AotRepositoryBeanDefinitionPropertiesDecorator.RESERVED_TYPES.values());
    }

    @Override
    public void addParameter(String parameterName, ResolvableType type, Consumer<AotRepositoryConstructorBuilder.ConstructorParameterCustomizer> customizer) {
        this.parametersAdded.add(parameterName);
        Supplier<AotRepositoryFragmentMetadata.ConstructorArgument> constructorArgumentSupplier = () -> {
            ConstructorParameterContext context = new ConstructorParameterContext(this::localVariable, parameterName, type);
            customizer.accept(context);
            return new AotRepositoryFragmentMetadata.ConstructorArgument(parameterName, type, context.bindToField, context.getRequiredParameterOrigin());
        };
        this.metadata.addConstructorArgument(parameterName, type, constructorArgumentSupplier);
    }

    @Override
    public void customize(AotRepositoryConstructorBuilder.ConstructorCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"ConstructorCustomizer must not be null");
        this.customizer = customizer;
    }

    public String localVariable(String variableName) {
        return this.localVariables.computeIfAbsent(variableName, this.variableNameFactory::generateName);
    }

    public MethodSpec buildConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> parameter : this.metadata.getConstructorArguments().entrySet()) {
            builder.addParameter(parameter.getValue().typeName(), parameter.getKey(), new Modifier[0]);
        }
        CodeBlock.Builder customCtorCode = CodeBlock.builder();
        this.customizer.customize(customCtorCode);
        if (!customCtorCode.isEmpty()) {
            builder.addCode(customCtorCode.build());
        }
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> parameter : this.metadata.getConstructorArguments().entrySet()) {
            if (!parameter.getValue().isBoundToField()) continue;
            builder.addStatement("this.$N = $N", new Object[]{parameter.getKey(), parameter.getKey()});
        }
        return builder.build();
    }

    public void dispose() {
        for (String parameterName : this.parametersAdded) {
            AotRepositoryFragmentMetadata.ConstructorArgument removedArgument = this.metadata.getConstructorArguments().remove(parameterName);
            if (removedArgument == null || !removedArgument.isBoundToField()) continue;
            this.metadata.getFields().remove(parameterName);
        }
    }

    class ConstructorParameterContext
    implements AotRepositoryConstructorBuilder.ConstructorParameterCustomizer {
        private final VariableNameFactory variableFactory;
        private final String parameterName;
        private final TypeName typeName;
        boolean bindToField;
        @Nullable AotRepositoryConstructorBuilder.ParameterOrigin block;

        ConstructorParameterContext(VariableNameFactory variableFactory, String parameterName, ResolvableType resolvableType) {
            this.variableFactory = variableFactory;
            this.parameterName = parameterName;
            this.typeName = AotRepositoryFragmentMetadata.typeNameOf(resolvableType);
            if (resolvableType.isAssignableFrom(BeanFactory.class)) {
                this.origin(AotRepositoryConstructorBuilder.FragmentParameterContext::getBeanFactory);
            } else if (resolvableType.isAssignableFrom(RepositoryFactoryBeanSupport.FragmentCreationContext.class)) {
                this.origin(AotRepositoryConstructorBuilder.FragmentParameterContext::getFragmentCreationContext);
            } else {
                this.origin((BeanReference)new RuntimeBeanReference(resolvableType.toClass()));
            }
        }

        @Override
        public AotRepositoryConstructorBuilder.ConstructorParameterCustomizer bindToField(boolean bindToField) {
            this.bindToField = bindToField;
            return this;
        }

        @Override
        public void origin(BeanReference reference) {
            this.origin((AotRepositoryConstructorBuilder.FragmentParameterContext ctx) -> {
                RuntimeBeanReference rbr;
                CodeBlock.Builder builder = CodeBlock.builder();
                String variableName = ctx.localVariable(this.parameterName);
                if (reference instanceof RuntimeBeanReference && (rbr = (RuntimeBeanReference)reference).getBeanType() != null) {
                    if (rbr.getBeanName().equals(rbr.getBeanType().getName())) {
                        builder.addStatement("$1T $2L = $3L.getBean($4T.class)", new Object[]{this.typeName, variableName, ctx.beanFactory(), rbr.getBeanType()});
                    } else {
                        builder.addStatement("$1T $2L = $3L.getBean($4S, $5T.class)", new Object[]{this.typeName, variableName, ctx.beanFactory(), rbr.getBeanName(), rbr.getBeanType()});
                    }
                } else {
                    builder.addStatement("$1T $2L = ($1T) $3L.getBean($4S)", new Object[]{this.typeName, variableName, ctx.beanFactory(), reference.getBeanName()});
                }
                return AotRepositoryConstructorBuilder.ParameterOrigin.of(variableName, builder.build());
            });
        }

        @Override
        public void origin(Function<AotRepositoryConstructorBuilder.FragmentParameterContext, AotRepositoryConstructorBuilder.ParameterOrigin> originFunction) {
            AotRepositoryConstructorBuilder.FragmentParameterContext ctx = new AotRepositoryConstructorBuilder.FragmentParameterContext(){

                @Override
                public String beanFactory() {
                    return RepositoryConstructorBuilder.this.beanFactory;
                }

                @Override
                public String fragmentCreationContext() {
                    return RepositoryConstructorBuilder.this.fragmentCreationContext;
                }

                @Override
                public String localVariable(String variableName) {
                    return ConstructorParameterContext.this.variableFactory.generateName(variableName);
                }
            };
            this.block = originFunction.apply(ctx);
            Assert.state((this.block != null ? 1 : 0) != 0, (String)"Resulting ParameterOriginBlock must not be null");
        }

        public AotRepositoryConstructorBuilder.ParameterOrigin getRequiredParameterOrigin() {
            Assert.state((this.block != null ? 1 : 0) != 0, (String)"ParameterOriginBlock must not be null");
            return this.block;
        }
    }
}

