/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.core;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.core.PropertyReferenceException;
import org.springframework.data.core.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

class SimplePropertyPath
implements PropertyPath {
    private static final String PARSE_DEPTH_EXCEEDED = "Trying to parse a path with depth greater than 1000; This has been disabled for security reasons to prevent parsing overflows";
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private static final Pattern SPLITTER_FOR_QUOTED = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "\\."));
    private static final Pattern NESTED_PROPERTY_PATTERN = Pattern.compile("\\p{Lu}[\\p{Ll}\\p{Nd}]*$");
    private static final Map<Property, SimplePropertyPath> cache = new ConcurrentReferenceHashMap();
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> typeInformation;
    private final TypeInformation<?> actualTypeInformation;
    private final boolean isCollection;
    private @Nullable SimplePropertyPath next;

    SimplePropertyPath(String name, Class<?> owningType) {
        this(name, TypeInformation.of(owningType), Collections.emptyList());
    }

    SimplePropertyPath(String name, TypeInformation<?> owningType, List<SimplePropertyPath> base) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull(owningType, (String)"Owning type must not be null");
        Assert.notNull(base, (String)"Previously found properties must not be null");
        String decapitalized = Introspector.decapitalize(name);
        Property property = SimplePropertyPath.lookupProperty(owningType, decapitalized);
        if (property == null) {
            property = SimplePropertyPath.lookupProperty(owningType, StringUtils.uncapitalize((String)name));
        }
        if (property == null) {
            throw new PropertyReferenceException(decapitalized, owningType, base);
        }
        this.owningType = owningType;
        this.name = property.path;
        this.typeInformation = property.type;
        this.isCollection = this.typeInformation.isCollectionLike();
        this.actualTypeInformation = this.typeInformation.getActualType() == null ? this.typeInformation : this.typeInformation.getRequiredActualType();
    }

    private static @Nullable Property lookupProperty(TypeInformation<?> owningType, String name) {
        TypeInformation<?> propertyType = owningType.getProperty(name);
        return propertyType != null ? new Property(propertyType, name) : null;
    }

    @Override
    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    @Override
    public String getSegment() {
        return this.name;
    }

    @Override
    public Class<?> getLeafType() {
        return this.getLeafProperty().getType();
    }

    @Override
    public Class<?> getType() {
        return this.actualTypeInformation.getType();
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public @Nullable SimplePropertyPath next() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public boolean isCollection() {
        return this.isCollection;
    }

    @Override
    public SimplePropertyPath nested(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        String lookup = this.toDotPath().concat(".").concat(path);
        return SimplePropertyPath.from(lookup, this.owningType);
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private @Nullable SimplePropertyPath current;
            {
                this.current = SimplePropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public @Nullable SimplePropertyPath next() {
                SimplePropertyPath result = this.current;
                if (result == null) {
                    return null;
                }
                this.current = result.next();
                return result;
            }
        };
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePropertyPath)) {
            return false;
        }
        SimplePropertyPath that = (SimplePropertyPath)o;
        if (this.isCollection != that.isCollection) {
            return false;
        }
        return Objects.equals(this.owningType, that.owningType) && Objects.equals(this.name, that.name) && Objects.equals(this.typeInformation, that.typeInformation) && Objects.equals(this.actualTypeInformation, that.actualTypeInformation) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.owningType, this.name, this.typeInformation, this.actualTypeInformation, this.isCollection, this.next);
    }

    private SimplePropertyPath requiredNext() {
        SimplePropertyPath result = this.next;
        if (result == null) {
            throw new IllegalStateException("No next path available; Clients should call hasNext() before invoking this method");
        }
        return result;
    }

    public static SimplePropertyPath from(String source, Class<?> type) {
        return SimplePropertyPath.from(source, TypeInformation.of(type));
    }

    public static SimplePropertyPath from(String source, TypeInformation<?> type) {
        Assert.hasText((String)source, (String)"Source must not be null or empty");
        Assert.notNull(type, (String)"TypeInformation must not be null or empty");
        return cache.computeIfAbsent(new Property(type, source), it -> {
            Matcher matcher;
            ArrayList<String> iteratorSource = new ArrayList<String>();
            Matcher matcher2 = matcher = SimplePropertyPath.isQuoted(it.path) ? SPLITTER_FOR_QUOTED.matcher(it.path.replace("\\Q", "").replace("\\E", "")) : SPLITTER.matcher("_" + it.path);
            while (matcher.find()) {
                iteratorSource.add(matcher.group(1));
            }
            Iterator parts = iteratorSource.iterator();
            SimplePropertyPath result = null;
            Stack<SimplePropertyPath> current = new Stack<SimplePropertyPath>();
            while (parts.hasNext()) {
                if (result == null) {
                    result = SimplePropertyPath.create((String)parts.next(), it.type, current);
                    current.push(result);
                    continue;
                }
                current.push(SimplePropertyPath.create((String)parts.next(), current));
            }
            if (result == null) {
                throw new IllegalStateException(String.format("Expected parsing to yield a PropertyPath from %s but got null", source));
            }
            return result;
        });
    }

    private static boolean isQuoted(String source) {
        return source.matches("^\\\\Q.*\\\\E$");
    }

    private static SimplePropertyPath create(String source, Stack<SimplePropertyPath> base) {
        SimplePropertyPath propertyPath;
        SimplePropertyPath previous = base.peek();
        previous.next = propertyPath = SimplePropertyPath.create(source, previous.typeInformation.getRequiredActualType(), base);
        return propertyPath;
    }

    private static SimplePropertyPath create(String source, TypeInformation<?> type, List<SimplePropertyPath> base) {
        return SimplePropertyPath.create(source, type, "", base);
    }

    private static SimplePropertyPath create(String source, TypeInformation<?> type, String addTail, List<SimplePropertyPath> base) {
        if (base.size() > 1000) {
            throw new IllegalArgumentException(PARSE_DEPTH_EXCEEDED);
        }
        PropertyReferenceException exception = null;
        SimplePropertyPath current = null;
        try {
            current = new SimplePropertyPath(source, type, base);
            if (!base.isEmpty()) {
                base.get((int)(base.size() - 1)).next = current;
            }
            ArrayList<SimplePropertyPath> newBase = new ArrayList<SimplePropertyPath>(base);
            newBase.add(current);
            if (StringUtils.hasText((String)addTail)) {
                current.next = SimplePropertyPath.create(addTail, current.actualTypeInformation, newBase);
            }
            return current;
        }
        catch (PropertyReferenceException e) {
            if (current != null) {
                throw e;
            }
            exception = e;
            Matcher matcher = NESTED_PROPERTY_PATTERN.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                try {
                    return SimplePropertyPath.create(head, type, tail + addTail, base);
                }
                catch (PropertyReferenceException e2) {
                    throw e2.hasDeeperResolutionDepthThan(exception) ? e2 : exception;
                }
            }
            throw exception;
        }
    }

    public String toString() {
        return String.format("%s.%s", this.owningType.getType().getSimpleName(), this.toDotPath());
    }

    private static final class Property {
        private final TypeInformation<?> type;
        private final String path;

        private Property(TypeInformation<?> type, String path) {
            this.type = type;
            this.path = path;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property that = (Property)obj;
            return Objects.equals(this.type, that.type) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.path);
        }

        public String toString() {
            return "Key[type=" + String.valueOf(this.type) + ", path=" + this.path + "]";
        }
    }
}

