/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.KotlinDefaultMask;
import org.springframework.data.mapping.model.KotlinValueUtils;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;

class KotlinInstantiationDelegate {
    private final PreferredConstructor<?, ?> constructor;
    private final KFunction<?> constructorFunction;
    private final List<KParameter> kParameters;
    private final Map<KParameter, Integer> indexByKParameter;
    private final List<Function<Object, Object>> wrappers;
    private final boolean hasDefaultConstructorMarker;

    private KotlinInstantiationDelegate(PreferredConstructor<?, ?> constructor, KFunction<?> constructorFunction) {
        this.constructor = constructor;
        this.hasDefaultConstructorMarker = KotlinInstantiationDelegate.hasDefaultConstructorMarker(this.getConstructor().getParameters());
        this.constructorFunction = constructorFunction;
        this.kParameters = constructorFunction.getParameters();
        this.indexByKParameter = new IdentityHashMap<KParameter, Integer>(this.kParameters.size());
        for (int i = 0; i < this.kParameters.size(); ++i) {
            this.indexByKParameter.put(this.kParameters.get(i), i);
        }
        this.wrappers = new ArrayList<Function<Object, Object>>(this.kParameters.size());
        for (KParameter kParameter : this.kParameters) {
            KotlinValueUtils.ValueBoxing valueBoxing = KotlinValueUtils.getConstructorValueHierarchy(kParameter);
            this.wrappers.add(valueBoxing::wrap);
        }
    }

    public InstanceCreatorMetadata<?> getInstanceCreator() {
        return this.constructor;
    }

    public Constructor<?> getConstructor() {
        return this.constructor.getConstructor();
    }

    public int getRequiredParameterCount() {
        return this.getConstructor().getParameterCount();
    }

    public <P extends PersistentProperty<P>> Object[] extractInvocationArguments(Object[] params, @Nullable InstanceCreatorMetadata<P> entityCreator, ParameterValueProvider<P> provider) {
        int i;
        if (entityCreator == null) {
            throw new IllegalArgumentException("EntityCreator must not be null");
        }
        int userParameterCount = this.kParameters.size();
        List parameters = entityCreator.getParameters();
        for (i = 0; i < userParameterCount; ++i) {
            Parameter<Object, P> parameter = parameters.get(i);
            params[i] = provider.getParameterValue(parameter);
        }
        for (i = 0; i < userParameterCount; ++i) {
            params[i] = this.wrappers.get(i).apply(params[i]);
        }
        if (this.hasDefaultConstructorMarker) {
            KotlinDefaultMask defaultMask = KotlinDefaultMask.forConstructor(this.constructorFunction, it -> {
                int index = this.indexByKParameter.get(it);
                Parameter parameter = (Parameter)parameters.get(index);
                Class type = parameter.getType().getType();
                if (it.isOptional() && params[index] == null) {
                    if (type.isPrimitive()) {
                        params[index] = ReflectionUtils.getPrimitiveDefault(type);
                    }
                    return false;
                }
                return true;
            });
            int[] defaulting = defaultMask.getDefaulting();
            for (int i2 = 0; i2 < defaulting.length; ++i2) {
                params[userParameterCount + i2] = defaulting[i2];
            }
        }
        return params;
    }

    @Nullable
    public static KotlinInstantiationDelegate resolve(PreferredConstructor<?, ?> preferredConstructor) {
        KFunction constructorFunction = ReflectJvmMapping.getKotlinFunction(preferredConstructor.getConstructor());
        if (constructorFunction == null) {
            return null;
        }
        PreferredConstructor<?, ?> resolved = KotlinInstantiationDelegate.resolveKotlinJvmConstructor(preferredConstructor, constructorFunction);
        return resolved != null ? new KotlinInstantiationDelegate(resolved, constructorFunction) : null;
    }

    @Nullable
    private static PreferredConstructor<?, ?> resolveKotlinJvmConstructor(PreferredConstructor<?, ?> preferredConstructor, KFunction<?> constructorFunction) {
        Constructor<?> hit = KotlinInstantiationDelegate.findKotlinConstructor(preferredConstructor.getConstructor(), constructorFunction);
        if (preferredConstructor.getConstructor().equals(hit)) {
            return preferredConstructor;
        }
        if (hit != null) {
            return new PreferredConstructor(hit, preferredConstructor.getParameters().toArray(new Parameter[0]));
        }
        return null;
    }

    @Nullable
    private static Constructor<?> findKotlinConstructor(Constructor<?> preferredConstructor, KFunction<?> constructorFunction) {
        Class<?> entityType = preferredConstructor.getDeclaringClass();
        Constructor<?> hit = null;
        Constructor<?> privateFallback = null;
        java.lang.reflect.Parameter[] detectedParameters = preferredConstructor.getParameters();
        boolean hasDefaultConstructorMarker = KotlinInstantiationDelegate.hasDefaultConstructorMarker(detectedParameters);
        for (Constructor<?> candidate : entityType.getDeclaredConstructors()) {
            int userParameterCount;
            int syntheticParameters;
            int optionalParameterCount;
            int syntheticParameters2;
            java.lang.reflect.Parameter[] candidateParameters;
            java.lang.reflect.Parameter[] parameterArray = candidateParameters = preferredConstructor.equals(candidate) ? detectedParameters : candidate.getParameters();
            if (Modifier.isPrivate(candidate.getModifiers()) && preferredConstructor.equals(candidate)) {
                privateFallback = candidate;
            }
            if (!candidate.isSynthetic() || (hasDefaultConstructorMarker ? detectedParameters.length + (syntheticParameters2 = KotlinDefaultMask.getExactMaskCount(optionalParameterCount = KotlinInstantiationDelegate.getOptionalParameterCount(constructorFunction))) != candidate.getParameterCount() : detectedParameters.length + (syntheticParameters = KotlinDefaultMask.getMaskCount(detectedParameters.length) + 1) != candidate.getParameterCount())) continue;
            if (!KotlinInstantiationDelegate.hasDefaultConstructorMarker(candidateParameters) || !KotlinInstantiationDelegate.parametersMatch(detectedParameters, candidateParameters, userParameterCount = constructorFunction.getParameters().size())) continue;
            hit = candidate;
        }
        if (hit == null) {
            return privateFallback;
        }
        return hit;
    }

    private static int getOptionalParameterCount(KFunction<?> function) {
        int count = 0;
        for (KParameter parameter : function.getParameters()) {
            if (!parameter.isOptional()) continue;
            ++count;
        }
        return count;
    }

    private static boolean parametersMatch(java.lang.reflect.Parameter[] constructorParameters, java.lang.reflect.Parameter[] candidateParameters, int userParameterCount) {
        for (int i = 0; i < userParameterCount; ++i) {
            if (KotlinInstantiationDelegate.parametersMatch(constructorParameters[i].getType(), candidateParameters[i].getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersMatch(Class<?> constructorParameter, Class<?> candidateParameter) {
        if (constructorParameter.equals(candidateParameter)) {
            return true;
        }
        Class<?> componentOrWrapperType = KotlinValueUtils.getConstructorValueHierarchy(candidateParameter).getActualType();
        return constructorParameter.equals(componentOrWrapperType);
    }

    private static boolean hasDefaultConstructorMarker(java.lang.reflect.Parameter[] parameters) {
        return parameters.length > 0 && KotlinInstantiationDelegate.isDefaultConstructorMarker(parameters[parameters.length - 1].getType());
    }

    private static boolean isDefaultConstructorMarker(Class<?> cls) {
        return cls.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker");
    }
}

