/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.frame.FrameType;
import io.rsocket.metadata.CompositeMetadataCodec;
import io.rsocket.metadata.RoutingMetadata;
import io.rsocket.metadata.TracingMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.util.RSocketProxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.rsocket.CompositeMetadataUtils;
import org.springframework.cloud.sleuth.instrument.rsocket.PayloadUtils;
import org.springframework.cloud.sleuth.instrument.rsocket.SleuthRSocketSpan;
import org.springframework.cloud.sleuth.internal.EncodingUtils;
import org.springframework.cloud.sleuth.propagation.Propagator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.ContextView;

public class TracingRequesterRSocketProxy
extends RSocketProxy {
    private static final Log log = LogFactory.getLog(TracingRequesterRSocketProxy.class);
    private final Propagator propagator;
    private final Propagator.Setter<CompositeByteBuf> setter;
    private final Tracer tracer;
    private final boolean isZipkinPropagationEnabled;

    public TracingRequesterRSocketProxy(RSocket source, Propagator propagator, Propagator.Setter<CompositeByteBuf> setter, Tracer tracer, boolean isZipkinPropagationEnabled) {
        super(source);
        this.propagator = propagator;
        this.setter = setter;
        this.tracer = tracer;
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    private void clearThreadLocal() {
        this.tracer.withSpan(null);
    }

    public Mono<Void> fireAndForget(Payload payload) {
        this.clearThreadLocal();
        return this.setSpan((Payload x$0) -> super.fireAndForget(x$0), payload, FrameType.REQUEST_FNF);
    }

    public Mono<Payload> requestResponse(Payload payload) {
        this.clearThreadLocal();
        return this.setSpan((Payload x$0) -> super.requestResponse(x$0), payload, FrameType.REQUEST_RESPONSE);
    }

    <T> Mono<T> setSpan(Function<Payload, Mono<T>> input, Payload payload, FrameType frameType) {
        return Mono.deferContextual(contextView -> {
            Span.Builder spanBuilder = this.spanBuilder((ContextView)contextView);
            ByteBuf extracted = CompositeMetadataUtils.extract(payload.sliceMetadata(), WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString());
            RoutingMetadata routingMetadata = new RoutingMetadata(extracted);
            Iterator iterator = routingMetadata.iterator();
            String route = (String)iterator.next();
            AssertingSpan span = AssertingSpanBuilder.of((DocumentedSpan)SleuthRSocketSpan.RSOCKET_REQUESTER_SPAN, (Span.Builder)spanBuilder.kind(Span.Kind.PRODUCER)).name(frameType.name() + " " + route).tag((TagKey)SleuthRSocketSpan.Tags.ROUTE, route).tag((TagKey)SleuthRSocketSpan.Tags.REQUEST_TYPE, frameType.name()).start();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Extracted result from context or thread local " + span));
            }
            Payload newPayload = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
            TraceContext traceContext = span.context();
            CompositeByteBuf metadata = (CompositeByteBuf)newPayload.metadata();
            if (this.isZipkinPropagationEnabled) {
                this.injectDefaultZipkinRSocketHeaders(metadata, traceContext);
            }
            this.propagator.inject(traceContext, (Object)metadata, this.setter);
            return ((Mono)input.apply(newPayload)).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(arg_0 -> TracingRequesterRSocketProxy.lambda$null$2((Span)span, arg_0));
        });
    }

    void injectDefaultZipkinRSocketHeaders(CompositeByteBuf metadata, TraceContext traceContext) {
        TracingMetadataCodec.Flags flags = traceContext.sampled() == null ? TracingMetadataCodec.Flags.UNDECIDED : (traceContext.sampled() != false ? TracingMetadataCodec.Flags.SAMPLE : TracingMetadataCodec.Flags.NOT_SAMPLE);
        String traceId = traceContext.traceId();
        long[] traceIds = EncodingUtils.fromString(traceId);
        long[] spanId = EncodingUtils.fromString(traceContext.spanId());
        long[] parentSpanId = EncodingUtils.fromString(traceContext.parentId());
        boolean isTraceId128Bit = traceIds.length == 2;
        ByteBufAllocator allocator = metadata.alloc();
        if (isTraceId128Bit) {
            CompositeMetadataCodec.encodeAndAddMetadata((CompositeByteBuf)metadata, (ByteBufAllocator)allocator, (WellKnownMimeType)WellKnownMimeType.MESSAGE_RSOCKET_TRACING_ZIPKIN, (ByteBuf)TracingMetadataCodec.encode128((ByteBufAllocator)allocator, (long)traceIds[0], (long)traceIds[1], (long)spanId[0], (long)EncodingUtils.fromString(traceContext.parentId())[0], (TracingMetadataCodec.Flags)flags));
        } else {
            CompositeMetadataCodec.encodeAndAddMetadata((CompositeByteBuf)metadata, (ByteBufAllocator)allocator, (WellKnownMimeType)WellKnownMimeType.MESSAGE_RSOCKET_TRACING_ZIPKIN, (ByteBuf)TracingMetadataCodec.encode64((ByteBufAllocator)allocator, (long)traceIds[0], (long)spanId[0], (long)parentSpanId[0], (TracingMetadataCodec.Flags)flags));
        }
    }

    Span.Builder spanBuilder(ContextView contextView) {
        Span.Builder spanBuilder = this.tracer.spanBuilder();
        if (contextView.hasKey(TraceContext.class)) {
            spanBuilder = spanBuilder.setParent((TraceContext)contextView.get(TraceContext.class));
        } else if (this.tracer.currentSpan() != null) {
            spanBuilder = spanBuilder.setParent(this.tracer.currentSpan().context());
        }
        return spanBuilder;
    }

    public Flux<Payload> requestStream(Payload payload) {
        this.clearThreadLocal();
        return Flux.deferContextual(contextView -> this.setSpan((Payload x$0) -> super.requestStream(x$0), payload, (ContextView)contextView));
    }

    public Flux<Payload> requestChannel(Publisher<Payload> inbound) {
        this.clearThreadLocal();
        return Flux.from(inbound).switchOnFirst((firstSignal, flux) -> {
            Payload firstPayload = (Payload)firstSignal.get();
            if (firstPayload != null) {
                return this.setSpan((Payload p) -> super.requestChannel((Publisher)flux.skip(1L).startWith((Object[])new Payload[]{p})), firstPayload, firstSignal.getContextView());
            }
            return flux;
        });
    }

    <T> Flux<Payload> setSpan(Function<Payload, Flux<Payload>> input, Payload payload, ContextView contextView) {
        Span.Builder spanBuilder = this.spanBuilder(contextView);
        RoutingMetadata routingMetadata = new RoutingMetadata(CompositeMetadataUtils.extract(payload.sliceMetadata(), WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString()));
        Iterator iterator = routingMetadata.iterator();
        AssertingSpan span = AssertingSpanBuilder.of((DocumentedSpan)SleuthRSocketSpan.RSOCKET_REQUESTER_SPAN, (Span.Builder)spanBuilder.kind(Span.Kind.PRODUCER)).name((String)iterator.next()).start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted result from context or thread local " + span));
        }
        Payload newPayload = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
        this.propagator.inject(span.context(), (Object)((CompositeByteBuf)newPayload.metadata()), this.setter);
        return input.apply(newPayload).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(arg_0 -> TracingRequesterRSocketProxy.lambda$setSpan$8((Span)span, arg_0));
    }

    private static /* synthetic */ void lambda$setSpan$8(Span span, SignalType signalType) {
        span.end();
    }

    private static /* synthetic */ void lambda$null$2(Span span, SignalType signalType) {
        span.end();
    }
}

