/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.session;

import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.session.SleuthSessionSpan;
import org.springframework.cloud.sleuth.instrument.session.TraceSessionRepository;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.SessionRepository;

class TraceFindByIndexNameSessionRepository
extends TraceSessionRepository
implements FindByIndexNameSessionRepository {
    private final FindByIndexNameSessionRepository delegate;

    TraceFindByIndexNameSessionRepository(Tracer tracer, FindByIndexNameSessionRepository delegate) {
        super(tracer, (SessionRepository)delegate);
        this.delegate = delegate;
    }

    /*
     * Loose catch block
     */
    public Map findByPrincipalName(String principalName) {
        AssertingSpan span = this.newSessionFindSpan();
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpan((Span)span.start());){
                Map map = this.delegate.findByPrincipalName(principalName);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.end();
        }
    }

    private AssertingSpan newSessionFindSpan() {
        return AssertingSpan.of((DocumentedSpan)SleuthSessionSpan.SESSION_FIND_SPAN, (Span)this.tracer.nextSpan()).name(SleuthSessionSpan.SESSION_FIND_SPAN.getName());
    }

    /*
     * Loose catch block
     */
    public Map findByIndexNameAndIndexValue(String indexName, String indexValue) {
        AssertingSpan span = this.newSessionFindSpan();
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpan((Span)span.start());){
                span.tag((TagKey)SleuthSessionSpan.Tags.INDEX_NAME, indexName);
                Map map = this.delegate.findByIndexNameAndIndexValue(indexName, indexValue);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.end();
        }
    }
}

