/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.LinkedMultiValueMap;

public class MessageHeaderPropagatorSetter
implements Propagator.Setter<MessageHeaderAccessor> {
    private static final Log log = LogFactory.getLog(MessageHeaderPropagatorSetter.class);

    static Map<String, ?> propagationHeaders(Map<String, ?> headers, List<String> propagationHeaders) {
        HashMap headersToCopy = new HashMap();
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            if (!propagationHeaders.contains(entry.getKey())) continue;
            headersToCopy.put(entry.getKey(), entry.getValue());
        }
        return headersToCopy;
    }

    static void removeAnyTraceHeaders(MessageHeaderAccessor accessor, List<String> keysToRemove) {
        for (String keyToRemove : keysToRemove) {
            accessor.removeHeader(keyToRemove);
            if (accessor instanceof NativeMessageHeaderAccessor) {
                NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
                if (!accessor.isMutable()) continue;
                MessageHeaderPropagatorSetter.ensureNativeHeadersAreMutable(nativeAccessor).removeNativeHeader(keyToRemove);
                continue;
            }
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (!(nativeHeaders instanceof Map)) continue;
            ((Map)nativeHeaders).remove(keyToRemove);
        }
    }

    private static NativeMessageHeaderAccessor ensureNativeHeadersAreMutable(NativeMessageHeaderAccessor nativeAccessor) {
        Map nativeHeaderMap = nativeAccessor.toNativeHeaderMap();
        nativeHeaderMap = nativeHeaderMap instanceof LinkedMultiValueMap ? nativeHeaderMap : new LinkedMultiValueMap(nativeHeaderMap);
        nativeAccessor.removeHeader("nativeHeaders");
        nativeAccessor.setHeader("nativeHeaders", (Object)nativeHeaderMap);
        return nativeAccessor;
    }

    public void set(MessageHeaderAccessor accessor, String key, String value) {
        block2: {
            try {
                this.doPut(accessor, key, value);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("An exception happened when we tried to retrieve the [" + key + "] from message"), (Throwable)ex);
            }
        }
    }

    private void doPut(MessageHeaderAccessor accessor, String key, String value) {
        accessor.setHeader(key, (Object)value);
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            MessageHeaderPropagatorSetter.ensureNativeHeadersAreMutable(nativeAccessor).setNativeHeader(key, value);
        } else {
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (nativeHeaders == null) {
                nativeHeaders = new LinkedMultiValueMap();
                accessor.setHeader("nativeHeaders", nativeHeaders);
            }
            if (nativeHeaders instanceof Map) {
                Map<String, List<String>> copy = this.toNativeHeaderMap((Map)nativeHeaders);
                copy.put(key, Collections.singletonList(value));
                accessor.setHeader("nativeHeaders", copy);
            }
        }
    }

    private Map<String, List<String>> toNativeHeaderMap(Map<String, List<String>> map) {
        return map != null ? new LinkedMultiValueMap(map) : Collections.emptyMap();
    }

    public String toString() {
        return "MessageHeaderPropagatorSetter{}";
    }
}

