/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rsocket;

import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.rsocket.ByteBufGetter;
import org.springframework.cloud.sleuth.instrument.rsocket.ByteBufSetter;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingRequesterRSocketProxy;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingResponderRSocketProxy;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;

public class TracingRSocketConnectorConfigurer
implements RSocketConnectorConfigurer {
    private final Propagator propagator;
    private final Tracer tracer;
    private final boolean isZipkinPropagationEnabled;

    public TracingRSocketConnectorConfigurer(Propagator propagator, Tracer tracer, boolean isZipkinPropagationEnabled) {
        this.propagator = propagator;
        this.tracer = tracer;
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    public void configure(RSocketConnector rSocketConnector) {
        rSocketConnector.interceptors(ir -> ir.forResponder(rSocket -> new TracingResponderRSocketProxy((RSocket)rSocket, this.propagator, new ByteBufGetter(), this.tracer, this.isZipkinPropagationEnabled)).forRequester(rSocket -> new TracingRequesterRSocketProxy((RSocket)rSocket, this.propagator, new ByteBufSetter(), this.tracer, this.isZipkinPropagationEnabled)));
    }
}

