/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kotlin;

import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.ThreadContextElement;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.Tracer;

class KotlinContextElement
implements ThreadContextElement<SpanAndScope> {
    static final CoroutineContext.Key<KotlinContextElement> KEY = new CoroutineContext.Key<KotlinContextElement>(){};
    private final Span span;
    private final Tracer tracer;

    KotlinContextElement(Tracer tracer) {
        this.tracer = tracer;
        this.span = tracer.currentSpan();
    }

    Span getSpan() {
        return this.span;
    }

    public CoroutineContext.Key<?> getKey() {
        return KEY;
    }

    public SpanAndScope updateThreadContext(CoroutineContext coroutineContext) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(this.span);
        return new SpanAndScope(this.span, spanInScope);
    }

    public void restoreThreadContext(CoroutineContext coroutineContext, SpanAndScope spanAndScope) {
        spanAndScope.close();
    }

    public CoroutineContext plus(CoroutineContext coroutineContext) {
        return CoroutineContext.DefaultImpls.plus((CoroutineContext)this, (CoroutineContext)coroutineContext);
    }

    public <R> R fold(R initial, Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineContext.Element.DefaultImpls.fold((CoroutineContext.Element)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(CoroutineContext.Key<E> key) {
        return (E)CoroutineContext.Element.DefaultImpls.get((CoroutineContext.Element)this, key);
    }

    public CoroutineContext minusKey(CoroutineContext.Key<?> key) {
        return CoroutineContext.Element.DefaultImpls.minusKey((CoroutineContext.Element)this, key);
    }
}

