/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JaxRsBodyParser;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.util.StringUtils;

class JaxRsRequestMethodWhen
implements When,
JaxRsBodyParser {
    private final BlockBuilder blockBuilder;
    private final BodyReader bodyReader;

    JaxRsRequestMethodWhen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = new BodyReader(metaData);
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.appendMethodAndBody(metadata);
        return this;
    }

    void appendMethodAndBody(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        ContentType type = metadata.getInputTestContentType();
        String method = request.getMethod().getServerValue().toString().toLowerCase();
        if (request.getBody() != null) {
            FromFileProperty fileProperty;
            String contentType = StringUtils.hasText((String)metadata.getDefinedInputTestContentType()) ? metadata.getDefinedInputTestContentType() : type.getMimeType();
            Object body = request.getBody().getServerValue();
            Object value = body instanceof ExecutionProperty ? body.toString() : (body instanceof FromFileProperty ? ((fileProperty = (FromFileProperty)body).isByte() ? this.bodyReader.readBytesFromFileString(metadata, fileProperty, CommunicationType.REQUEST) : this.bodyReader.readStringFromFileString(metadata, fileProperty, CommunicationType.REQUEST)) : "\"" + this.requestBodyAsString(metadata) + "\"");
            this.blockBuilder.addIndented(".build(\"" + method.toUpperCase() + "\", entity(" + (String)value + ", \"" + contentType + "\"))");
        } else {
            this.blockBuilder.addIndented(".build(\"" + method.toUpperCase() + "\")");
        }
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return true;
    }
}

