/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.autoconfigure.reactive;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.reactive.ConfigurableReactiveWebServerFactory;
import org.springframework.core.Ordered;

public class ReactiveWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableReactiveWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;
    private final @Nullable SslBundles sslBundles;

    public ReactiveWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this(serverProperties, null);
    }

    public ReactiveWebServerFactoryCustomizer(ServerProperties serverProperties, @Nullable SslBundles sslBundles) {
        this.serverProperties = serverProperties;
        this.sslBundles = sslBundles;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableReactiveWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get();
        map.from(this.serverProperties::getPort).to(factory::setPort);
        map.from(this.serverProperties::getAddress).to(factory::setAddress);
        map.from(this.serverProperties::getSsl).to(factory::setSsl);
        map.from(this.serverProperties::getCompression).to(factory::setCompression);
        map.from(this.serverProperties::getHttp2).to(factory::setHttp2);
        map.from((Object)this.serverProperties.getShutdown()).to(factory::setShutdown);
        map.from(() -> this.sslBundles).to(factory::setSslBundles);
    }
}

